"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/removeReactionMutation.graphql");

  if (node.hash && node.hash !== "f20b76a0ff63579992f4631894495523") {
    console.error("The definition of 'removeReactionMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/removeReactionMutation.graphql");
};

var _default = (environment, subjectId, content) => {
  const variables = {
    input: {
      content,
      subjectId
    }
  };

  function optimisticUpdater(store) {
    const subject = store.get(subjectId);
    const reactionGroups = subject.getLinkedRecords('reactionGroups') || [];
    const reactionGroup = reactionGroups.find(group => group.getValue('content') === content);

    if (!reactionGroup) {
      return;
    }

    reactionGroup.setValue(false, 'viewerHasReacted');
    const conn = reactionGroup.getLinkedRecord('users');
    conn.setValue(conn.getValue('totalCount') - 1, 'totalCount');
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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