"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/addReactionMutation.graphql");

  if (node.hash && node.hash !== "fc238aed25f2d7e854162002cb00b57f") {
    console.error("The definition of 'addReactionMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/addReactionMutation.graphql");
};

let placeholderID = 0;

var _default = (environment, subjectId, content) => {
  const variables = {
    input: {
      content,
      subjectId
    }
  };

  function optimisticUpdater(store) {
    const subject = store.get(subjectId);
    const reactionGroups = subject.getLinkedRecords('reactionGroups') || [];
    const reactionGroup = reactionGroups.find(group => group.getValue('content') === content);

    if (!reactionGroup) {
      const group = store.create(`add-reaction:reaction-group:${placeholderID++}`, 'ReactionGroup');
      group.setValue(true, 'viewerHasReacted');
      group.setValue(content, 'content');
      const conn = store.create(`add-reaction:reacting-user-conn:${placeholderID++}`, 'ReactingUserConnection');
      conn.setValue(1, 'totalCount');
      group.setLinkedRecord(conn, 'users');
      subject.setLinkedRecords([...reactionGroups, group], 'reactionGroups');
      return;
    }

    reactionGroup.setValue(true, 'viewerHasReacted');
    const conn = reactionGroup.getLinkedRecord('users');
    conn.setValue(conn.getValue('totalCount') + 1, 'totalCount');
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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