"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

var _relayRuntime = require("relay-runtime");

var _helpers = require("../helpers");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/addPrReviewMutation.graphql");

  if (node.hash && node.hash !== "d2960bba4729b6c3e91e249ea582fec1") {
    console.error("The definition of 'addPrReviewMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/addPrReviewMutation.graphql");
};

let placeholderID = 0;

var _default = (environment, {
  body,
  event,
  pullRequestID,
  viewerID
}) => {
  const variables = {
    input: {
      pullRequestId: pullRequestID
    }
  };

  if (body) {
    variables.input.body = body;
  }

  if (event) {
    variables.input.event = event;
  }

  const configs = [{
    type: 'RANGE_ADD',
    parentID: pullRequestID,
    connectionInfo: [{
      key: 'ReviewSummariesAccumulator_reviews',
      rangeBehavior: 'append'
    }],
    edgeName: 'reviewEdge'
  }];

  function optimisticUpdater(store) {
    const pullRequest = store.get(pullRequestID);

    if (!pullRequest) {
      return;
    }

    const id = `add-pr-review:review:${placeholderID++}`;
    const review = store.create(id, 'PullRequestReview');
    review.setValue(id, 'id');
    review.setValue('PENDING', 'state');
    review.setValue(body, 'body');
    review.setValue(body ? (0, _helpers.renderMarkdown)(body) : '...', 'bodyHTML');
    review.setLinkedRecords([], 'reactionGroups');
    review.setValue(false, 'viewerCanReact');
    review.setValue(false, 'viewerCanUpdate');
    let author;

    if (viewerID) {
      author = store.get(viewerID);
    } else {
      author = store.create(`add-pr-review-comment:author:${placeholderID++}`, 'User');
      author.setValue('...', 'login');
      author.setValue('atom://github/img/avatar.svg', 'avatarUrl');
    }

    review.setLinkedRecord(author, 'author');

    const reviews = _relayRuntime.ConnectionHandler.getConnection(pullRequest, 'ReviewSummariesAccumulator_reviews');

    const edge = _relayRuntime.ConnectionHandler.createEdge(store, reviews, review, 'PullRequestReviewEdge');

    _relayRuntime.ConnectionHandler.insertEdgeAfter(reviews, edge);
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      configs,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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