"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Initial state to be used when it's uncertain whether or not a git repository is present in a working directory. If
 * it is a git repository, transition to Present, otherwise transition to Empty.
 */
class Loading extends _state["default"] {
  async start() {
    const dotGitDir = await this.resolveDotGitDir();

    if (dotGitDir) {
      this.repository.setGitDirectoryPath(dotGitDir);
      const history = await this.loadHistoryPayload();
      return this.transitionTo('Present', history);
    } else {
      return this.transitionTo('Empty');
    }
  }

  isLoading() {
    return true;
  }

  async init() {
    await this.getLoadPromise();
    await this.repository.init();
  }

  async clone(remoteUrl) {
    await this.getLoadPromise();
    await this.repository.clone(remoteUrl);
  }

  showGitTabLoading() {
    return true;
  }

  directResolveDotGitDir() {
    return this.git().resolveDotGitDir();
  }

  directGetConfig(key, options) {
    return this.git().getConfig(key, options);
  }

  directGetBlobContents(sha) {
    return this.git().getBlobContents(sha);
  }

}

exports["default"] = Loading;

_state["default"].register(Loading);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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