"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Git is asynchronously initializing a new repository in this working directory.
 */
class Initializing extends _state["default"] {
  async start() {
    await this.doInit(this.workdir());
    await this.transitionTo('Loading');
  }

  showGitTabLoading() {
    return true;
  }

  directInit(workdir) {
    return this.git().init(workdir);
  }

}

exports["default"] = Initializing;

_state["default"].register(Initializing);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluaXRpYWxpemluZy5qcyJdLCJuYW1lcyI6WyJJbml0aWFsaXppbmciLCJTdGF0ZSIsInN0YXJ0IiwiZG9Jbml0Iiwid29ya2RpciIsInRyYW5zaXRpb25UbyIsInNob3dHaXRUYWJMb2FkaW5nIiwiZGlyZWN0SW5pdCIsImdpdCIsImluaXQiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7O0FBRUE7OztBQUdlLE1BQU1BLFlBQU4sU0FBMkJDLGlCQUEzQixDQUFpQztBQUM5QyxRQUFNQyxLQUFOLEdBQWM7QUFDWixVQUFNLEtBQUtDLE1BQUwsQ0FBWSxLQUFLQyxPQUFMLEVBQVosQ0FBTjtBQUVBLFVBQU0sS0FBS0MsWUFBTCxDQUFrQixTQUFsQixDQUFOO0FBQ0Q7O0FBRURDLEVBQUFBLGlCQUFpQixHQUFHO0FBQ2xCLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxFQUFBQSxVQUFVLENBQUNILE9BQUQsRUFBVTtBQUNsQixXQUFPLEtBQUtJLEdBQUwsR0FBV0MsSUFBWCxDQUFnQkwsT0FBaEIsQ0FBUDtBQUNEOztBQWI2Qzs7OztBQWdCaERILGtCQUFNUyxRQUFOLENBQWVWLFlBQWYiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFN0YXRlIGZyb20gJy4vc3RhdGUnO1xuXG4vKipcbiAqIEdpdCBpcyBhc3luY2hyb25vdXNseSBpbml0aWFsaXppbmcgYSBuZXcgcmVwb3NpdG9yeSBpbiB0aGlzIHdvcmtpbmcgZGlyZWN0b3J5LlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBJbml0aWFsaXppbmcgZXh0ZW5kcyBTdGF0ZSB7XG4gIGFzeW5jIHN0YXJ0KCkge1xuICAgIGF3YWl0IHRoaXMuZG9Jbml0KHRoaXMud29ya2RpcigpKTtcblxuICAgIGF3YWl0IHRoaXMudHJhbnNpdGlvblRvKCdMb2FkaW5nJyk7XG4gIH1cblxuICBzaG93R2l0VGFiTG9hZGluZygpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGRpcmVjdEluaXQod29ya2Rpcikge1xuICAgIHJldHVybiB0aGlzLmdpdCgpLmluaXQod29ya2Rpcik7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoSW5pdGlhbGl6aW5nKTtcbiJdfQ==