"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE = exports.THEIRS = exports.OURS = void 0;

class Source {
  constructor(name, uiString, cssClass) {
    this.name = name.toLowerCase();
    this.uiString = uiString;
    this.cssClass = cssClass;
  }

  when(actions) {
    const chosen = actions[this.name] || actions["default"] || (() => {
      throw new Error(`Unexpected conflict side source: ${this.name}`);
    });

    return chosen();
  }

  getName() {
    return this.name;
  }

  getCSSClass() {
    return this.cssClass;
  }

  getBannerCSSClass() {
    return this.cssClass + 'Banner';
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toUIString() {
    return this.uiString;
  }

  toString() {
    return `<Source: ${this.name.toUpperCase()}>`;
  }

}

const OURS = new Source('OURS', 'our changes', 'github-ConflictOurs');
exports.OURS = OURS;
const THEIRS = new Source('THEIRS', 'their changes', 'github-ConflictTheirs');
exports.THEIRS = THEIRS;
const BASE = new Source('BASE', 'common ancestor', 'github-ConflictBase');
exports.BASE = BASE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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