"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _eventKit = require("event-kit");

class ResolutionProgress {
  constructor() {
    this.emitter = new _eventKit.Emitter();
    this.markerCountByPath = new Map();
  }

  didUpdate() {
    this.emitter.emit('did-update');
  }

  onDidUpdate(cb) {
    return this.emitter.on('did-update', cb);
  }

  reportMarkerCount(path, count) {
    const previous = this.markerCountByPath.get(path);
    this.markerCountByPath.set(path, count);

    if (count !== previous) {
      this.didUpdate();
    }
  }

  getRemaining(path) {
    return this.markerCountByPath.get(path);
  }

  isEmpty() {
    return this.markerCountByPath.size === 0;
  }

}

exports["default"] = ResolutionProgress;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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