"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BOTTOM = exports.MIDDLE = exports.TOP = void 0;

class Position {
  constructor(name, cssClass) {
    this.name = name.toLowerCase();
    this.cssClass = cssClass;
  }

  getName() {
    return this.name;
  }

  when(actions) {
    const chosen = actions[this.name] || actions["default"] || (() => {
      throw new Error(`Unexpected conflict side position: ${this.name}`);
    });

    return chosen();
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toString() {
    return `<Position: ${this.name.toUpperCase()}>`;
  }

}

const TOP = new Position('TOP', 'github-ConflictTop');
exports.TOP = TOP;
const MIDDLE = new Position('MIDDLE', 'github-ConflictMiddle');
exports.MIDDLE = MIDDLE;
const BOTTOM = new Position('BOTTOM', 'github-ConflictBottom');
exports.BOTTOM = BOTTOM;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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