"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _path = _interopRequireDefault(require("path"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _eventKit = require("event-kit");

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _resolutionProgress = _interopRequireDefault(require("../models/conflicts/resolution-progress"));

var _editorConflictController = _interopRequireDefault(require("./editor-conflict-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const DEFAULT_REPO_DATA = {
  mergeConflictPaths: [],
  isRebasing: false
};
/**
 * Render an `EditorConflictController` for each `TextEditor` open on a file that contains git conflict markers.
 */

class RepositoryConflictController extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "fetchData", repository => {
      return (0, _yubikiri["default"])({
        workingDirectoryPath: repository.getWorkingDirectoryPath(),
        mergeConflictPaths: repository.getMergeConflicts().then(conflicts => {
          return conflicts.map(conflict => conflict.filePath);
        }),
        isRebasing: repository.isRebasing()
      });
    });

    this.state = {
      openEditors: this.props.workspace.getTextEditors()
    };
    this.subscriptions = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    const updateState = () => {
      this.setState({
        openEditors: this.props.workspace.getTextEditors()
      });
    };

    this.subscriptions.add(this.props.workspace.observeTextEditors(updateState), this.props.workspace.onDidDestroyPaneItem(updateState), this.props.config.observe('github.graphicalConflictResolution', () => this.forceUpdate()));
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.repository,
      fetchData: this.fetchData
    }, data => this.renderWithData(data || DEFAULT_REPO_DATA));
  }

  renderWithData(repoData) {
    const conflictingEditors = this.getConflictingEditors(repoData);
    return _react["default"].createElement("div", null, conflictingEditors.map(editor => _react["default"].createElement(_editorConflictController["default"], {
      key: editor.id,
      commands: this.props.commands,
      resolutionProgress: this.props.resolutionProgress,
      editor: editor,
      isRebase: repoData.isRebasing,
      refreshResolutionProgress: this.props.refreshResolutionProgress
    })));
  }

  getConflictingEditors(repoData) {
    if (repoData.mergeConflictPaths.length === 0 || this.state.openEditors.length === 0 || !this.props.config.get('github.graphicalConflictResolution')) {
      return [];
    }

    const commonBasePath = this.props.repository.getWorkingDirectoryPath();
    const fullMergeConflictPaths = new Set(repoData.mergeConflictPaths.map(relativePath => _path["default"].join(commonBasePath, relativePath)));
    return this.state.openEditors.filter(editor => fullMergeConflictPaths.has(editor.getPath()));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

}

exports["default"] = RepositoryConflictController;

_defineProperty(RepositoryConflictController, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  resolutionProgress: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object.isRequired,
  refreshResolutionProgress: _propTypes["default"].func
});

_defineProperty(RepositoryConflictController, "defaultProps", {
  refreshResolutionProgress: () => {},
  resolutionProgress: new _resolutionProgress["default"]()
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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