"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reporterProxy = require("../reporter-proxy");

var _eventKit = require("event-kit");

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _uriPattern = _interopRequireDefault(require("../atom/uri-pattern"));

var _recentCommitsView = _interopRequireDefault(require("../views/recent-commits-view"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RecentCommitsController extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "updateSelectedCommit", () => {
      const activeItem = this.props.workspace.getActivePaneItem();
      const pattern = new _uriPattern["default"](decodeURIComponent(_commitDetailItem["default"].buildURI(this.props.repository.getWorkingDirectoryPath(), '{sha}')));

      if (activeItem && activeItem.getURI) {
        const match = pattern.matches(activeItem.getURI());
        const {
          sha
        } = match.getParams();

        if (match.ok() && sha && sha !== this.state.selectedCommitSha) {
          return new Promise(resolve => this.setState({
            selectedCommitSha: sha
          }, resolve));
        }
      }

      return Promise.resolve();
    });

    _defineProperty(this, "openCommit", async ({
      sha,
      preserveFocus
    }) => {
      const workdir = this.props.repository.getWorkingDirectoryPath();

      const uri = _commitDetailItem["default"].buildURI(workdir, sha);

      const item = await this.props.workspace.open(uri, {
        pending: true
      });

      if (preserveFocus) {
        item.preventFocus();
        this.setFocus(this.constructor.focus.RECENT_COMMIT);
      }

      (0, _reporterProxy.addEvent)('open-commit-in-pane', {
        "package": 'github',
        from: this.constructor.name
      });
    });

    _defineProperty(this, "selectNextCommit", () => this.setSelectedCommitIndex(this.getSelectedCommitIndex() + 1));

    _defineProperty(this, "selectPreviousCommit", () => this.setSelectedCommitIndex(Math.max(this.getSelectedCommitIndex() - 1, 0)));

    this.subscriptions = new _eventKit.CompositeDisposable(this.props.workspace.onDidChangeActivePaneItem(this.updateSelectedCommit));
    this.refView = new _refHolder["default"]();
    this.state = {
      selectedCommitSha: ''
    };
  }

  render() {
    return _react["default"].createElement(_recentCommitsView["default"], {
      ref: this.refView.setter,
      commits: this.props.commits,
      isLoading: this.props.isLoading,
      undoLastCommit: this.props.undoLastCommit,
      openCommit: this.openCommit,
      selectNextCommit: this.selectNextCommit,
      selectPreviousCommit: this.selectPreviousCommit,
      selectedCommitSha: this.state.selectedCommitSha,
      commands: this.props.commands
    });
  }

  getSelectedCommitIndex() {
    return this.props.commits.findIndex(commit => commit.getSha() === this.state.selectedCommitSha);
  }

  setSelectedCommitIndex(ind) {
    const commit = this.props.commits[ind];

    if (commit) {
      return new Promise(resolve => this.setState({
        selectedCommitSha: commit.getSha()
      }, resolve));
    } else {
      return Promise.resolve();
    }
  }

  getFocus(element) {
    return this.refView.map(view => view.getFocus(element)).getOr(null);
  }

  setFocus(focus) {
    return this.refView.map(view => {
      const wasFocused = view.setFocus(focus);

      if (wasFocused && this.getSelectedCommitIndex() === -1) {
        this.setSelectedCommitIndex(0);
      }

      return wasFocused;
    }).getOr(false);
  }

  advanceFocusFrom(focus) {
    return this.refView.map(view => view.advanceFocusFrom(focus)).getOr(Promise.resolve(null));
  }

  retreatFocusFrom(focus) {
    return this.refView.map(view => view.retreatFocusFrom(focus)).getOr(Promise.resolve(null));
  }

}

exports["default"] = RecentCommitsController;

_defineProperty(RecentCommitsController, "propTypes", {
  commits: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  undoLastCommit: _propTypes["default"].func.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired
});

_defineProperty(RecentCommitsController, "focus", _recentCommitsView["default"].focus);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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