"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactionPickerView = _interopRequireDefault(require("../views/reaction-picker-view"));

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReactionPickerController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "addReactionAndClose", async content => {
      await this.props.addReaction(content);
      (0, _reporterProxy.addEvent)('add-emoji-reaction', {
        "package": 'github'
      });
      this.props.tooltipHolder.map(tooltip => tooltip.dispose());
    });

    _defineProperty(this, "removeReactionAndClose", async content => {
      await this.props.removeReaction(content);
      (0, _reporterProxy.addEvent)('remove-emoji-reaction', {
        "package": 'github'
      });
      this.props.tooltipHolder.map(tooltip => tooltip.dispose());
    });
  }

  render() {
    return _react["default"].createElement(_reactionPickerView["default"], _extends({
      addReactionAndClose: this.addReactionAndClose,
      removeReactionAndClose: this.removeReactionAndClose
    }, this.props));
  }

}

exports["default"] = ReactionPickerController;

_defineProperty(ReactionPickerController, "propTypes", {
  addReaction: _propTypes["default"].func.isRequired,
  removeReaction: _propTypes["default"].func.isRequired,
  tooltipHolder: _propTypes2.RefHolderPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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