"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _path = _interopRequireDefault(require("path"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _author = _interopRequireDefault(require("../models/author"));

var _gitTabView = _interopRequireDefault(require("../views/git-tab-view"));

var _userStore = _interopRequireDefault(require("../models/user-store"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitTabController extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'attemptStageAllOperation', 'attemptFileStageOperation', 'unstageFiles', 'prepareToCommit', 'commit', 'updateSelectedCoAuthors', 'undoLastCommit', 'abortMerge', 'resolveAsOurs', 'resolveAsTheirs', 'checkout', 'rememberLastFocus', 'quietlySelectItem');
    this.stagingOperationInProgress = false;
    this.lastFocus = _gitTabView["default"].focus.STAGING;
    this.refView = new _refHolder["default"]();
    this.refRoot = new _refHolder["default"]();
    this.refStagingView = new _refHolder["default"]();
    this.state = {
      selectedCoAuthors: []
    };
    this.userStore = new _userStore["default"]({
      repository: this.props.repository,
      login: this.props.loginModel,
      config: this.props.config
    });
  }

  render() {
    return _react["default"].createElement(_gitTabView["default"], {
      ref: this.refView.setter,
      refRoot: this.refRoot,
      refStagingView: this.refStagingView,
      isLoading: this.props.fetchInProgress,
      repository: this.props.repository,
      lastCommit: this.props.lastCommit,
      recentCommits: this.props.recentCommits,
      isMerging: this.props.isMerging,
      isRebasing: this.props.isRebasing,
      hasUndoHistory: this.props.hasUndoHistory,
      currentBranch: this.props.currentBranch,
      unstagedChanges: this.props.unstagedChanges,
      stagedChanges: this.props.stagedChanges,
      mergeConflicts: this.props.mergeConflicts,
      workingDirectoryPath: this.props.workingDirectoryPath,
      mergeMessage: this.props.mergeMessage,
      userStore: this.userStore,
      selectedCoAuthors: this.state.selectedCoAuthors,
      updateSelectedCoAuthors: this.updateSelectedCoAuthors,
      resolutionProgress: this.props.resolutionProgress,
      workspace: this.props.workspace,
      commands: this.props.commands,
      grammars: this.props.grammars,
      tooltips: this.props.tooltips,
      notificationManager: this.props.notificationManager,
      project: this.props.project,
      confirm: this.props.confirm,
      config: this.props.config,
      openInitializeDialog: this.props.openInitializeDialog,
      openFiles: this.props.openFiles,
      discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
      undoLastDiscard: this.props.undoLastDiscard,
      attemptFileStageOperation: this.attemptFileStageOperation,
      attemptStageAllOperation: this.attemptStageAllOperation,
      prepareToCommit: this.prepareToCommit,
      commit: this.commit,
      undoLastCommit: this.undoLastCommit,
      push: this.push,
      pull: this.pull,
      fetch: this.fetch,
      checkout: this.checkout,
      abortMerge: this.abortMerge,
      resolveAsOurs: this.resolveAsOurs,
      resolveAsTheirs: this.resolveAsTheirs
    });
  }

  componentDidMount() {
    this.refreshResolutionProgress(false, false);
    this.refRoot.map(root => root.addEventListener('focusin', this.rememberLastFocus));

    if (this.props.controllerRef) {
      this.props.controllerRef.setter(this);
    }
  }

  componentDidUpdate() {
    this.userStore.setRepository(this.props.repository);
    this.userStore.setLoginModel(this.props.loginModel);
    this.refreshResolutionProgress(false, false);
  }

  componentWillUnmount() {
    this.refRoot.map(root => root.removeEventListener('focusin', this.rememberLastFocus));
  }
  /*
   * Begin (but don't await) an async conflict-counting task for each merge conflict path that has no conflict
   * marker count yet. Omit any path that's already open in a TextEditor or that has already been counted.
   *
   * includeOpen - update marker counts for files that are currently open in TextEditors
   * includeCounted - update marker counts for files that have been counted before
   */


  refreshResolutionProgress(includeOpen, includeCounted) {
    if (this.props.fetchInProgress) {
      return;
    }

    const openPaths = new Set(this.props.workspace.getTextEditors().map(editor => editor.getPath()));

    for (let i = 0; i < this.props.mergeConflicts.length; i++) {
      const conflictPath = _path["default"].join(this.props.workingDirectoryPath, this.props.mergeConflicts[i].filePath);

      if (!includeOpen && openPaths.has(conflictPath)) {
        continue;
      }

      if (!includeCounted && this.props.resolutionProgress.getRemaining(conflictPath) !== undefined) {
        continue;
      }

      this.props.refreshResolutionProgress(conflictPath);
    }
  }

  attemptStageAllOperation(stageStatus) {
    return this.attemptFileStageOperation(['.'], stageStatus);
  }

  attemptFileStageOperation(filePaths, stageStatus) {
    if (this.stagingOperationInProgress) {
      return {
        stageOperationPromise: Promise.resolve(),
        selectionUpdatePromise: Promise.resolve()
      };
    }

    this.stagingOperationInProgress = true;
    const fileListUpdatePromise = this.refStagingView.map(view => {
      return view.getNextListUpdatePromise();
    }).getOr(Promise.resolve());
    let stageOperationPromise;

    if (stageStatus === 'staged') {
      stageOperationPromise = this.unstageFiles(filePaths);
    } else {
      stageOperationPromise = this.stageFiles(filePaths);
    }

    const selectionUpdatePromise = fileListUpdatePromise.then(() => {
      this.stagingOperationInProgress = false;
    });
    return {
      stageOperationPromise,
      selectionUpdatePromise
    };
  }

  async stageFiles(filePaths) {
    const pathsToStage = new Set(filePaths);
    const mergeMarkers = await Promise.all(filePaths.map(async filePath => {
      return {
        filePath,
        hasMarkers: await this.props.repository.pathHasMergeMarkers(filePath)
      };
    }));

    for (const _ref of mergeMarkers) {
      const {
        filePath,
        hasMarkers
      } = _ref;

      if (hasMarkers) {
        const choice = this.props.confirm({
          message: 'File contains merge markers: ',
          detailedMessage: `Do you still want to stage this file?\n${filePath}`,
          buttons: ['Stage', 'Cancel']
        });

        if (choice !== 0) {
          pathsToStage["delete"](filePath);
        }
      }
    }

    return this.props.repository.stageFiles(Array.from(pathsToStage));
  }

  unstageFiles(filePaths) {
    return this.props.repository.unstageFiles(filePaths);
  }

  async prepareToCommit() {
    return !(await this.props.ensureGitTab());
  }

  commit(message, options) {
    return this.props.repository.commit(message, options);
  }

  updateSelectedCoAuthors(selectedCoAuthors, newAuthor) {
    if (newAuthor) {
      this.userStore.addUsers([newAuthor]);
      selectedCoAuthors = selectedCoAuthors.concat([newAuthor]);
    }

    this.setState({
      selectedCoAuthors
    });
  }

  async undoLastCommit() {
    const repo = this.props.repository;
    const lastCommit = await repo.getLastCommit();

    if (lastCommit.isUnbornRef()) {
      return null;
    }

    await repo.undoLastCommit();
    repo.setCommitMessage(lastCommit.getFullMessage());
    const coAuthors = lastCommit.getCoAuthors().map(author => new _author["default"](author.email, author.name));
    this.updateSelectedCoAuthors(coAuthors);
    return null;
  }

  async abortMerge() {
    const choice = this.props.confirm({
      message: 'Abort merge',
      detailedMessage: 'Are you sure?',
      buttons: ['Abort', 'Cancel']
    });

    if (choice !== 0) {
      return;
    }

    try {
      await this.props.repository.abortMerge();
    } catch (e) {
      if (e.code === 'EDIRTYSTAGED') {
        this.props.notificationManager.addError(`Cannot abort because ${e.path} is both dirty and staged.`, {
          dismissable: true
        });
      } else {
        throw e;
      }
    }
  }

  async resolveAsOurs(paths) {
    if (this.props.fetchInProgress) {
      return;
    }

    const side = this.props.isRebasing ? 'theirs' : 'ours';
    await this.props.repository.checkoutSide(side, paths);
    this.refreshResolutionProgress(false, true);
  }

  async resolveAsTheirs(paths) {
    if (this.props.fetchInProgress) {
      return;
    }

    const side = this.props.isRebasing ? 'ours' : 'theirs';
    await this.props.repository.checkoutSide(side, paths);
    this.refreshResolutionProgress(false, true);
  }

  checkout(branchName, options) {
    return this.props.repository.checkout(branchName, options);
  }

  rememberLastFocus(event) {
    this.lastFocus = this.refView.map(view => view.getFocus(event.target)).getOr(null) || _gitTabView["default"].focus.STAGING;
  }

  restoreFocus() {
    this.refView.map(view => view.setFocus(this.lastFocus));
  }

  hasFocus() {
    return this.refRoot.map(root => root.contains(document.activeElement)).getOr(false);
  }

  wasActivated(isStillActive) {
    process.nextTick(() => {
      isStillActive() && this.restoreFocus();
    });
  }

  focusAndSelectStagingItem(filePath, stagingStatus) {
    return this.refView.map(view => view.focusAndSelectStagingItem(filePath, stagingStatus)).getOr(null);
  }

  focusAndSelectCommitPreviewButton() {
    return this.refView.map(view => view.focusAndSelectCommitPreviewButton());
  }

  focusAndSelectRecentCommit() {
    return this.refView.map(view => view.focusAndSelectRecentCommit());
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.refView.map(view => view.quietlySelectItem(filePath, stagingStatus)).getOr(null);
  }

}

exports["default"] = GitTabController;

_defineProperty(GitTabController, "focus", _objectSpread2({}, _gitTabView["default"].focus));

_defineProperty(GitTabController, "propTypes", {
  repository: _propTypes["default"].object.isRequired,
  loginModel: _propTypes["default"].object.isRequired,
  lastCommit: _propTypes2.CommitPropType.isRequired,
  recentCommits: _propTypes["default"].arrayOf(_propTypes2.CommitPropType).isRequired,
  isMerging: _propTypes["default"].bool.isRequired,
  isRebasing: _propTypes["default"].bool.isRequired,
  hasUndoHistory: _propTypes["default"].bool.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  unstagedChanges: _propTypes["default"].arrayOf(_propTypes2.FilePatchItemPropType).isRequired,
  stagedChanges: _propTypes["default"].arrayOf(_propTypes2.FilePatchItemPropType).isRequired,
  mergeConflicts: _propTypes["default"].arrayOf(_propTypes2.MergeConflictItemPropType).isRequired,
  workingDirectoryPath: _propTypes["default"].string,
  mergeMessage: _propTypes["default"].string,
  fetchInProgress: _propTypes["default"].bool.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  grammars: _propTypes["default"].object.isRequired,
  resolutionProgress: _propTypes["default"].object.isRequired,
  notificationManager: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  project: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  confirm: _propTypes["default"].func.isRequired,
  ensureGitTab: _propTypes["default"].func.isRequired,
  refreshResolutionProgress: _propTypes["default"].func.isRequired,
  undoLastDiscard: _propTypes["default"].func.isRequired,
  discardWorkDirChangesForPaths: _propTypes["default"].func.isRequired,
  openFiles: _propTypes["default"].func.isRequired,
  openInitializeDialog: _propTypes["default"].func.isRequired,
  controllerRef: _propTypes2.RefHolderPropType
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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