"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dialogRequests = exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _initDialog = _interopRequireDefault(require("../views/init-dialog"));

var _cloneDialog = _interopRequireDefault(require("../views/clone-dialog"));

var _credentialDialog = _interopRequireDefault(require("../views/credential-dialog"));

var _openIssueishDialog = _interopRequireDefault(require("../views/open-issueish-dialog"));

var _openCommitDialog = _interopRequireDefault(require("../views/open-commit-dialog"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const DIALOG_COMPONENTS = {
  "null": NullDialog,
  init: _initDialog["default"],
  clone: _cloneDialog["default"],
  credential: _credentialDialog["default"],
  issueish: _openIssueishDialog["default"],
  commit: _openCommitDialog["default"]
};

class DialogsController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      requestInProgress: null,
      requestError: [null, null]
    });
  }

  render() {
    const DialogComponent = DIALOG_COMPONENTS[this.props.request.identifier];
    return _react["default"].createElement(DialogComponent, this.getCommonProps());
  }

  getCommonProps() {
    const {
      request
    } = this.props;
    const accept = request.isProgressing ? async (...args) => {
      this.setState({
        requestError: [null, null],
        requestInProgress: request
      });

      try {
        const result = await request.accept(...args);
        this.setState({
          requestInProgress: null
        });
        return result;
      } catch (error) {
        this.setState({
          requestError: [request, error],
          requestInProgress: null
        });
        return undefined;
      }
    } : (...args) => {
      this.setState({
        requestError: [null, null]
      });

      try {
        return request.accept(...args);
      } catch (error) {
        this.setState({
          requestError: [request, error]
        });
        return undefined;
      }
    };
    const wrapped = wrapDialogRequest(request, {
      accept
    });
    return {
      config: this.props.config,
      commands: this.props.commands,
      workspace: this.props.workspace,
      inProgress: this.state.requestInProgress === request,
      error: this.state.requestError[0] === request ? this.state.requestError[1] : null,
      request: wrapped
    };
  }

}

exports["default"] = DialogsController;

_defineProperty(DialogsController, "propTypes", {
  // Model
  request: _propTypes["default"].shape({
    identifier: _propTypes["default"].string.isRequired,
    isProgressing: _propTypes["default"].bool.isRequired
  }).isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired
});

function NullDialog() {
  return null;
}

class DialogRequest {
  constructor(identifier, params = {}) {
    this.identifier = identifier;
    this.params = params;
    this.isProgressing = false;

    this.accept = () => {};

    this.cancel = () => {};
  }

  onAccept(cb) {
    this.accept = cb;
  }

  onProgressingAccept(cb) {
    this.isProgressing = true;
    this.onAccept(cb);
  }

  onCancel(cb) {
    this.cancel = cb;
  }

  getParams() {
    return this.params;
  }

}

function wrapDialogRequest(original, {
  accept
}) {
  const dup = new DialogRequest(original.identifier, original.params);
  dup.isProgressing = original.isProgressing;
  dup.onAccept(accept);
  dup.onCancel(original.cancel);
  return dup;
}

const dialogRequests = {
  "null": {
    identifier: 'null',
    isProgressing: false,
    params: {},
    accept: () => {},
    cancel: () => {}
  },

  init({
    dirPath
  }) {
    return new DialogRequest('init', {
      dirPath
    });
  },

  clone(opts) {
    return new DialogRequest('clone', _objectSpread2({
      sourceURL: '',
      destPath: ''
    }, opts));
  },

  credential(opts) {
    return new DialogRequest('credential', _objectSpread2({
      includeUsername: false,
      includeRemember: false,
      prompt: 'Please authenticate'
    }, opts));
  },

  issueish() {
    return new DialogRequest('issueish');
  },

  commit() {
    return new DialogRequest('commit');
  }

};
exports.dialogRequests = dialogRequests;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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