"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _helpers = require("../helpers");

var _source = require("../models/conflicts/source");

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const {
  Menu,
  MenuItem
} = _electron.remote;

class ConflictController extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'showResolveMenu');
    this.state = {
      chosenSide: this.props.conflict.getChosenSide()
    };
  }

  resolveAsSequence(sources) {
    this.props.resolveAsSequence(sources);
    this.setState({
      chosenSide: this.props.conflict.getChosenSide()
    });
  }

  revert(side) {
    side.isModified() && side.revert();
    side.isBannerModified() && side.revertBanner();
  }

  showResolveMenu(event) {
    event.preventDefault();
    const menu = new Menu();
    menu.append(new MenuItem({
      label: 'Resolve as Ours',
      click: this.resolveAsSequence.bind(this, [_source.OURS])
    }));

    if (this.props.conflict.getSide(_source.BASE)) {
      menu.append(new MenuItem({
        label: 'Resolve as Base',
        click: this.resolveAsSequence.bind(this, [_source.BASE])
      }));
    }

    menu.append(new MenuItem({
      label: 'Resolve as Theirs',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS])
    }));
    menu.append(new MenuItem({
      type: 'separator'
    }));
    menu.append(new MenuItem({
      label: 'Resolve as Ours Then Theirs',
      click: this.resolveAsSequence.bind(this, [_source.OURS, _source.THEIRS])
    }));
    menu.append(new MenuItem({
      label: 'Resolve as Theirs Then Ours',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS, _source.OURS])
    }));
    menu.append(new MenuItem({
      type: 'separator'
    }));
    menu.append(new MenuItem({
      label: 'Dismiss',
      click: this.props.dismiss
    }));
    menu.popup(_electron.remote.getCurrentWindow());
  }

  render() {
    if (!this.state.chosenSide) {
      const ours = this.props.conflict.getSide(_source.OURS);
      const base = this.props.conflict.getSide(_source.BASE);
      const theirs = this.props.conflict.getSide(_source.THEIRS);
      return _react["default"].createElement("div", null, this.renderSide(ours), base && this.renderSide(base), _react["default"].createElement(_decoration["default"], {
        key: this.props.conflict.getSeparator().getMarker().id,
        editor: this.props.editor,
        decorable: this.props.conflict.getSeparator().getMarker(),
        type: "line",
        className: "github-ConflictSeparator"
      }), this.renderSide(theirs));
    } else if (!this.state.chosenSide.isEmpty()) {
      return _react["default"].createElement(_decoration["default"], {
        editor: this.props.editor,
        decorable: this.state.chosenSide.getMarker(),
        type: "line",
        className: "github-ResolvedLines"
      });
    } else {
      return null;
    }
  }

  renderSide(side) {
    const source = side.getSource();
    return _react["default"].createElement("div", null, _react["default"].createElement(_decoration["default"], {
      key: side.banner.marker.id,
      editor: this.props.editor,
      decorable: side.getBannerMarker(),
      type: "line",
      className: side.getBannerCSSClass()
    }), side.isBannerModified() || _react["default"].createElement(_decoration["default"], {
      key: 'banner-modified-' + side.banner.marker.id,
      editor: this.props.editor,
      decorable: side.getBannerMarker(),
      type: "line",
      className: "github-ConflictUnmodifiedBanner"
    }), _react["default"].createElement(_decoration["default"], {
      key: side.marker.id,
      editor: this.props.editor,
      decorable: side.getMarker(),
      type: "line",
      className: side.getLineCSSClass()
    }), _react["default"].createElement(_decoration["default"], {
      key: 'block-' + side.marker.id,
      editor: this.props.editor,
      decorable: side.getBlockMarker(),
      type: "block",
      position: side.getBlockPosition()
    }, _react["default"].createElement("div", {
      className: side.getBlockCSSClasses()
    }, _react["default"].createElement("span", {
      className: "github-ResolutionControls"
    }, _react["default"].createElement("button", {
      className: "btn btn-sm inline-block",
      onClick: () => this.resolveAsSequence([source])
    }, "Use me"), (side.isModified() || side.isBannerModified()) && _react["default"].createElement("button", {
      className: "btn btn-sm inline-block",
      onClick: () => this.revert(side)
    }, "Revert"), _react["default"].createElement(_octicon["default"], {
      icon: "ellipses",
      className: "inline-block",
      onClick: this.showResolveMenu
    })), _react["default"].createElement("span", {
      className: "github-SideDescription"
    }, source.toUIString()))));
  }

}

exports["default"] = ConflictController;

_defineProperty(ConflictController, "propTypes", {
  editor: _propTypes["default"].object.isRequired,
  conflict: _propTypes["default"].object.isRequired,
  resolveAsSequence: _propTypes["default"].func,
  dismiss: _propTypes["default"].func
});

_defineProperty(ConflictController, "defaultProps", {
  resolveAsSequence: sources => {},
  dismiss: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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