"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchContainer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, this.props.token);

    if (this.props.search.isNull()) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/issueishSearchContainerQuery.graphql");

      if (node.hash && node.hash !== "9b0a99c35f017d4c3013e5908990a61c") {
        console.error("The definition of 'issueishSearchContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/issueishSearchContainerQuery.graphql");
    });

    const variables = {
      query: this.props.search.createQuery(),
      first: this.props.limit,
      checkSuiteCount: _helpers.CHECK_SUITE_PAGE_SIZE,
      checkSuiteCursor: null,
      checkRunCount: _helpers.CHECK_RUN_PAGE_SIZE,
      checkRunCursor: null
    };
    return _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderQueryResult({
    error,
    props,
    retry
  }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    return _react["default"].createElement(_issueishListController["default"], _extends({
      total: props.search.issueCount,
      results: props.search.nodes,
      isLoading: false
    }, this.controllerProps()));
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: this.props.search.getName(),
      onOpenIssueish: this.props.onOpenIssueish,
      onOpenReviews: this.props.onOpenReviews,
      onOpenMore: () => this.props.onOpenSearch(this.props.search)
    };
  }

}

exports["default"] = IssueishSearchContainer;

_defineProperty(IssueishSearchContainer, "propTypes", {
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Search model
  limit: _propTypes["default"].number,
  search: _propTypes2.SearchPropType.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  // Action methods
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onOpenSearch: _propTypes["default"].func.isRequired,
  onOpenReviews: _propTypes["default"].func.isRequired
});

_defineProperty(IssueishSearchContainer, "defaultProps", {
  limit: 20
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlzc3VlaXNoLXNlYXJjaC1jb250YWluZXIuanMiXSwibmFtZXMiOlsiSXNzdWVpc2hTZWFyY2hDb250YWluZXIiLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJzdWIiLCJEaXNwb3NhYmxlIiwicmVuZGVyIiwiZW52aXJvbm1lbnQiLCJSZWxheU5ldHdvcmtMYXllck1hbmFnZXIiLCJnZXRFbnZpcm9ubWVudEZvckhvc3QiLCJlbmRwb2ludCIsInRva2VuIiwic2VhcmNoIiwiaXNOdWxsIiwiY29udHJvbGxlclByb3BzIiwicXVlcnkiLCJ2YXJpYWJsZXMiLCJjcmVhdGVRdWVyeSIsImZpcnN0IiwibGltaXQiLCJjaGVja1N1aXRlQ291bnQiLCJDSEVDS19TVUlURV9QQUdFX1NJWkUiLCJjaGVja1N1aXRlQ3Vyc29yIiwiY2hlY2tSdW5Db3VudCIsIkNIRUNLX1JVTl9QQUdFX1NJWkUiLCJjaGVja1J1bkN1cnNvciIsInJlbmRlclF1ZXJ5UmVzdWx0IiwiZXJyb3IiLCJyZXRyeSIsImRpc3Bvc2UiLCJyZW1vdGVPcGVyYXRpb25PYnNlcnZlciIsIm9uRGlkQ29tcGxldGUiLCJpc3N1ZUNvdW50Iiwibm9kZXMiLCJjb21wb25lbnRXaWxsVW5tb3VudCIsInRpdGxlIiwiZ2V0TmFtZSIsIm9uT3Blbklzc3VlaXNoIiwib25PcGVuUmV2aWV3cyIsIm9uT3Blbk1vcmUiLCJvbk9wZW5TZWFyY2giLCJFbmRwb2ludFByb3BUeXBlIiwiaXNSZXF1aXJlZCIsIlByb3BUeXBlcyIsInN0cmluZyIsIm51bWJlciIsIlNlYXJjaFByb3BUeXBlIiwiT3BlcmF0aW9uU3RhdGVPYnNlcnZlclByb3BUeXBlIiwiZnVuYyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOztBQUNBOztBQUNBOztBQUNBOzs7Ozs7Ozs7Ozs7QUFFZSxNQUFNQSx1QkFBTixTQUFzQ0Msa0JBQU1DLFNBQTVDLENBQXNEO0FBcUJuRUMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVE7QUFDakIsVUFBTUEsS0FBTjtBQUNBLDJCQUFTLElBQVQsRUFBZSxtQkFBZjtBQUVBLFNBQUtDLEdBQUwsR0FBVyxJQUFJQyxvQkFBSixFQUFYO0FBQ0Q7O0FBRURDLEVBQUFBLE1BQU0sR0FBRztBQUNQLFVBQU1DLFdBQVcsR0FBR0MscUNBQXlCQyxxQkFBekIsQ0FBK0MsS0FBS04sS0FBTCxDQUFXTyxRQUExRCxFQUFvRSxLQUFLUCxLQUFMLENBQVdRLEtBQS9FLENBQXBCOztBQUVBLFFBQUksS0FBS1IsS0FBTCxDQUFXUyxNQUFYLENBQWtCQyxNQUFsQixFQUFKLEVBQWdDO0FBQzlCLGFBQ0UsZ0NBQUMsa0RBQUQ7QUFDRSxRQUFBLFNBQVMsRUFBRTtBQURiLFNBRU0sS0FBS0MsZUFBTCxFQUZOLEVBREY7QUFNRDs7QUFFRCxVQUFNQyxLQUFLO0FBQUE7O0FBQUE7QUFBQTtBQUFBOztBQUFBO0FBQUEsTUFBWDs7QUFzQkEsVUFBTUMsU0FBUyxHQUFHO0FBQ2hCRCxNQUFBQSxLQUFLLEVBQUUsS0FBS1osS0FBTCxDQUFXUyxNQUFYLENBQWtCSyxXQUFsQixFQURTO0FBRWhCQyxNQUFBQSxLQUFLLEVBQUUsS0FBS2YsS0FBTCxDQUFXZ0IsS0FGRjtBQUdoQkMsTUFBQUEsZUFBZSxFQUFFQyw4QkFIRDtBQUloQkMsTUFBQUEsZ0JBQWdCLEVBQUUsSUFKRjtBQUtoQkMsTUFBQUEsYUFBYSxFQUFFQyw0QkFMQztBQU1oQkMsTUFBQUEsY0FBYyxFQUFFO0FBTkEsS0FBbEI7QUFTQSxXQUNFLGdDQUFDLHlCQUFEO0FBQ0UsTUFBQSxXQUFXLEVBQUVsQixXQURmO0FBRUUsTUFBQSxTQUFTLEVBQUVTLFNBRmI7QUFHRSxNQUFBLEtBQUssRUFBRUQsS0FIVDtBQUlFLE1BQUEsTUFBTSxFQUFFLEtBQUtXO0FBSmYsTUFERjtBQVFEOztBQUVEQSxFQUFBQSxpQkFBaUIsQ0FBQztBQUFDQyxJQUFBQSxLQUFEO0FBQVF4QixJQUFBQSxLQUFSO0FBQWV5QixJQUFBQTtBQUFmLEdBQUQsRUFBd0I7QUFDdkMsUUFBSUEsS0FBSixFQUFXO0FBQ1QsV0FBS3hCLEdBQUwsQ0FBU3lCLE9BQVQ7QUFDQSxXQUFLekIsR0FBTCxHQUFXLEtBQUtELEtBQUwsQ0FBVzJCLHVCQUFYLENBQW1DQyxhQUFuQyxDQUFpREgsS0FBakQsQ0FBWDtBQUNEOztBQUVELFFBQUlELEtBQUosRUFBVztBQUNULGFBQ0UsZ0NBQUMsa0RBQUQ7QUFDRSxRQUFBLFNBQVMsRUFBRSxLQURiO0FBRUUsUUFBQSxLQUFLLEVBQUVBO0FBRlQsU0FHTSxLQUFLYixlQUFMLEVBSE4sRUFERjtBQU9EOztBQUVELFFBQUlYLEtBQUssS0FBSyxJQUFkLEVBQW9CO0FBQ2xCLGFBQ0UsZ0NBQUMsa0RBQUQ7QUFDRSxRQUFBLFNBQVMsRUFBRTtBQURiLFNBRU0sS0FBS1csZUFBTCxFQUZOLEVBREY7QUFNRDs7QUFFRCxXQUNFLGdDQUFDLGtDQUFEO0FBQ0UsTUFBQSxLQUFLLEVBQUVYLEtBQUssQ0FBQ1MsTUFBTixDQUFhb0IsVUFEdEI7QUFFRSxNQUFBLE9BQU8sRUFBRTdCLEtBQUssQ0FBQ1MsTUFBTixDQUFhcUIsS0FGeEI7QUFHRSxNQUFBLFNBQVMsRUFBRTtBQUhiLE9BSU0sS0FBS25CLGVBQUwsRUFKTixFQURGO0FBUUQ7O0FBRURvQixFQUFBQSxvQkFBb0IsR0FBRztBQUNyQixTQUFLOUIsR0FBTCxDQUFTeUIsT0FBVDtBQUNEOztBQUVEZixFQUFBQSxlQUFlLEdBQUc7QUFDaEIsV0FBTztBQUNMcUIsTUFBQUEsS0FBSyxFQUFFLEtBQUtoQyxLQUFMLENBQVdTLE1BQVgsQ0FBa0J3QixPQUFsQixFQURGO0FBR0xDLE1BQUFBLGNBQWMsRUFBRSxLQUFLbEMsS0FBTCxDQUFXa0MsY0FIdEI7QUFJTEMsTUFBQUEsYUFBYSxFQUFFLEtBQUtuQyxLQUFMLENBQVdtQyxhQUpyQjtBQUtMQyxNQUFBQSxVQUFVLEVBQUUsTUFBTSxLQUFLcEMsS0FBTCxDQUFXcUMsWUFBWCxDQUF3QixLQUFLckMsS0FBTCxDQUFXUyxNQUFuQztBQUxiLEtBQVA7QUFPRDs7QUFoSWtFOzs7O2dCQUFoRGIsdUIsZUFDQTtBQUNqQjtBQUNBVyxFQUFBQSxRQUFRLEVBQUUrQiw2QkFBaUJDLFVBRlY7QUFHakIvQixFQUFBQSxLQUFLLEVBQUVnQyxzQkFBVUMsTUFBVixDQUFpQkYsVUFIUDtBQUtqQjtBQUNBdkIsRUFBQUEsS0FBSyxFQUFFd0Isc0JBQVVFLE1BTkE7QUFPakJqQyxFQUFBQSxNQUFNLEVBQUVrQywyQkFBZUosVUFQTjtBQVFqQlosRUFBQUEsdUJBQXVCLEVBQUVpQiwyQ0FBK0JMLFVBUnZDO0FBVWpCO0FBQ0FMLEVBQUFBLGNBQWMsRUFBRU0sc0JBQVVLLElBQVYsQ0FBZU4sVUFYZDtBQVlqQkYsRUFBQUEsWUFBWSxFQUFFRyxzQkFBVUssSUFBVixDQUFlTixVQVpaO0FBYWpCSixFQUFBQSxhQUFhLEVBQUVLLHNCQUFVSyxJQUFWLENBQWVOO0FBYmIsQzs7Z0JBREEzQyx1QixrQkFpQkc7QUFDcEJvQixFQUFBQSxLQUFLLEVBQUU7QUFEYSxDIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHtRdWVyeVJlbmRlcmVyLCBncmFwaHFsfSBmcm9tICdyZWFjdC1yZWxheSc7XG5pbXBvcnQge0Rpc3Bvc2FibGV9IGZyb20gJ2V2ZW50LWtpdCc7XG5cbmltcG9ydCB7YXV0b2JpbmQsIENIRUNLX1NVSVRFX1BBR0VfU0laRSwgQ0hFQ0tfUlVOX1BBR0VfU0laRX0gZnJvbSAnLi4vaGVscGVycyc7XG5pbXBvcnQge1NlYXJjaFByb3BUeXBlLCBPcGVyYXRpb25TdGF0ZU9ic2VydmVyUHJvcFR5cGUsIEVuZHBvaW50UHJvcFR5cGV9IGZyb20gJy4uL3Byb3AtdHlwZXMnO1xuaW1wb3J0IElzc3VlaXNoTGlzdENvbnRyb2xsZXIsIHtCYXJlSXNzdWVpc2hMaXN0Q29udHJvbGxlcn0gZnJvbSAnLi4vY29udHJvbGxlcnMvaXNzdWVpc2gtbGlzdC1jb250cm9sbGVyJztcbmltcG9ydCBSZWxheU5ldHdvcmtMYXllck1hbmFnZXIgZnJvbSAnLi4vcmVsYXktbmV0d29yay1sYXllci1tYW5hZ2VyJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgSXNzdWVpc2hTZWFyY2hDb250YWluZXIgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIC8vIENvbm5lY3Rpb24gaW5mb3JtYXRpb25cbiAgICBlbmRwb2ludDogRW5kcG9pbnRQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIHRva2VuOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBTZWFyY2ggbW9kZWxcbiAgICBsaW1pdDogUHJvcFR5cGVzLm51bWJlcixcbiAgICBzZWFyY2g6IFNlYXJjaFByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgcmVtb3RlT3BlcmF0aW9uT2JzZXJ2ZXI6IE9wZXJhdGlvblN0YXRlT2JzZXJ2ZXJQcm9wVHlwZS5pc1JlcXVpcmVkLFxuXG4gICAgLy8gQWN0aW9uIG1ldGhvZHNcbiAgICBvbk9wZW5Jc3N1ZWlzaDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBvbk9wZW5TZWFyY2g6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgb25PcGVuUmV2aWV3czogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHN0YXRpYyBkZWZhdWx0UHJvcHMgPSB7XG4gICAgbGltaXQ6IDIwLFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gICAgYXV0b2JpbmQodGhpcywgJ3JlbmRlclF1ZXJ5UmVzdWx0Jyk7XG5cbiAgICB0aGlzLnN1YiA9IG5ldyBEaXNwb3NhYmxlKCk7XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3QgZW52aXJvbm1lbnQgPSBSZWxheU5ldHdvcmtMYXllck1hbmFnZXIuZ2V0RW52aXJvbm1lbnRGb3JIb3N0KHRoaXMucHJvcHMuZW5kcG9pbnQsIHRoaXMucHJvcHMudG9rZW4pO1xuXG4gICAgaWYgKHRoaXMucHJvcHMuc2VhcmNoLmlzTnVsbCgpKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8QmFyZUlzc3VlaXNoTGlzdENvbnRyb2xsZXJcbiAgICAgICAgICBpc0xvYWRpbmc9e2ZhbHNlfVxuICAgICAgICAgIHsuLi50aGlzLmNvbnRyb2xsZXJQcm9wcygpfVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICB9XG5cbiAgICBjb25zdCBxdWVyeSA9IGdyYXBocWxgXG4gICAgICBxdWVyeSBpc3N1ZWlzaFNlYXJjaENvbnRhaW5lclF1ZXJ5KFxuICAgICAgICAkcXVlcnk6IFN0cmluZyFcbiAgICAgICAgJGZpcnN0OiBJbnQhXG4gICAgICAgICRjaGVja1N1aXRlQ291bnQ6IEludCFcbiAgICAgICAgJGNoZWNrU3VpdGVDdXJzb3I6IFN0cmluZ1xuICAgICAgICAkY2hlY2tSdW5Db3VudDogSW50IVxuICAgICAgICAkY2hlY2tSdW5DdXJzb3I6IFN0cmluZ1xuICAgICAgKSB7XG4gICAgICAgIHNlYXJjaChmaXJzdDogJGZpcnN0LCBxdWVyeTogJHF1ZXJ5LCB0eXBlOiBJU1NVRSkge1xuICAgICAgICAgIGlzc3VlQ291bnRcbiAgICAgICAgICBub2RlcyB7XG4gICAgICAgICAgICAuLi5pc3N1ZWlzaExpc3RDb250cm9sbGVyX3Jlc3VsdHMgQGFyZ3VtZW50cyhcbiAgICAgICAgICAgICAgY2hlY2tTdWl0ZUNvdW50OiAkY2hlY2tTdWl0ZUNvdW50XG4gICAgICAgICAgICAgIGNoZWNrU3VpdGVDdXJzb3I6ICRjaGVja1N1aXRlQ3Vyc29yXG4gICAgICAgICAgICAgIGNoZWNrUnVuQ291bnQ6ICRjaGVja1J1bkNvdW50XG4gICAgICAgICAgICAgIGNoZWNrUnVuQ3Vyc29yOiAkY2hlY2tSdW5DdXJzb3JcbiAgICAgICAgICAgIClcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICBgO1xuICAgIGNvbnN0IHZhcmlhYmxlcyA9IHtcbiAgICAgIHF1ZXJ5OiB0aGlzLnByb3BzLnNlYXJjaC5jcmVhdGVRdWVyeSgpLFxuICAgICAgZmlyc3Q6IHRoaXMucHJvcHMubGltaXQsXG4gICAgICBjaGVja1N1aXRlQ291bnQ6IENIRUNLX1NVSVRFX1BBR0VfU0laRSxcbiAgICAgIGNoZWNrU3VpdGVDdXJzb3I6IG51bGwsXG4gICAgICBjaGVja1J1bkNvdW50OiBDSEVDS19SVU5fUEFHRV9TSVpFLFxuICAgICAgY2hlY2tSdW5DdXJzb3I6IG51bGwsXG4gICAgfTtcblxuICAgIHJldHVybiAoXG4gICAgICA8UXVlcnlSZW5kZXJlclxuICAgICAgICBlbnZpcm9ubWVudD17ZW52aXJvbm1lbnR9XG4gICAgICAgIHZhcmlhYmxlcz17dmFyaWFibGVzfVxuICAgICAgICBxdWVyeT17cXVlcnl9XG4gICAgICAgIHJlbmRlcj17dGhpcy5yZW5kZXJRdWVyeVJlc3VsdH1cbiAgICAgIC8+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlclF1ZXJ5UmVzdWx0KHtlcnJvciwgcHJvcHMsIHJldHJ5fSkge1xuICAgIGlmIChyZXRyeSkge1xuICAgICAgdGhpcy5zdWIuZGlzcG9zZSgpO1xuICAgICAgdGhpcy5zdWIgPSB0aGlzLnByb3BzLnJlbW90ZU9wZXJhdGlvbk9ic2VydmVyLm9uRGlkQ29tcGxldGUocmV0cnkpO1xuICAgIH1cblxuICAgIGlmIChlcnJvcikge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPEJhcmVJc3N1ZWlzaExpc3RDb250cm9sbGVyXG4gICAgICAgICAgaXNMb2FkaW5nPXtmYWxzZX1cbiAgICAgICAgICBlcnJvcj17ZXJyb3J9XG4gICAgICAgICAgey4uLnRoaXMuY29udHJvbGxlclByb3BzKCl9XG4gICAgICAgIC8+XG4gICAgICApO1xuICAgIH1cblxuICAgIGlmIChwcm9wcyA9PT0gbnVsbCkge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPEJhcmVJc3N1ZWlzaExpc3RDb250cm9sbGVyXG4gICAgICAgICAgaXNMb2FkaW5nPXt0cnVlfVxuICAgICAgICAgIHsuLi50aGlzLmNvbnRyb2xsZXJQcm9wcygpfVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICB9XG5cbiAgICByZXR1cm4gKFxuICAgICAgPElzc3VlaXNoTGlzdENvbnRyb2xsZXJcbiAgICAgICAgdG90YWw9e3Byb3BzLnNlYXJjaC5pc3N1ZUNvdW50fVxuICAgICAgICByZXN1bHRzPXtwcm9wcy5zZWFyY2gubm9kZXN9XG4gICAgICAgIGlzTG9hZGluZz17ZmFsc2V9XG4gICAgICAgIHsuLi50aGlzLmNvbnRyb2xsZXJQcm9wcygpfVxuICAgICAgLz5cbiAgICApO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgdGhpcy5zdWIuZGlzcG9zZSgpO1xuICB9XG5cbiAgY29udHJvbGxlclByb3BzKCkge1xuICAgIHJldHVybiB7XG4gICAgICB0aXRsZTogdGhpcy5wcm9wcy5zZWFyY2guZ2V0TmFtZSgpLFxuXG4gICAgICBvbk9wZW5Jc3N1ZWlzaDogdGhpcy5wcm9wcy5vbk9wZW5Jc3N1ZWlzaCxcbiAgICAgIG9uT3BlblJldmlld3M6IHRoaXMucHJvcHMub25PcGVuUmV2aWV3cyxcbiAgICAgIG9uT3Blbk1vcmU6ICgpID0+IHRoaXMucHJvcHMub25PcGVuU2VhcmNoKHRoaXMucHJvcHMuc2VhcmNoKSxcbiAgICB9O1xuICB9XG59XG4iXX0=