"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _commentDecorationsController = _interopRequireDefault(require("../controllers/comment-decorations-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _helpers = require("../helpers");

var _aggregatedReviewsContainer = _interopRequireDefault(require("./aggregated-reviews-container"));

var _commentPositioningContainer = _interopRequireDefault(require("./comment-positioning-container"));

var _prPatchContainer = _interopRequireDefault(require("./pr-patch-container"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommentDecorationsContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithLocalRepositoryData", repoData => {
      if (!repoData) {
        return null;
      }

      return _react["default"].createElement(_observeModel["default"], {
        model: this.props.loginModel,
        fetchParams: [repoData],
        fetchData: this.fetchToken
      }, token => this.renderWithToken(token, {
        repoData
      }));
    });

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri["default"])({
        branches: repository.getBranches(),
        remotes: repository.getRemotes(),
        currentRemote: repository.getCurrentGitHubRemote(),
        workingDirectoryPath: repository.getWorkingDirectoryPath()
      });
    });

    _defineProperty(this, "fetchToken", (loginModel, repoData) => {
      const endpoint = repoData.currentRemote.getEndpoint();

      if (!endpoint) {
        return null;
      }

      return loginModel.getToken(endpoint.getLoginAccount());
    });
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.localRepository,
      fetchData: this.fetchRepositoryData
    }, this.renderWithLocalRepositoryData);
  }

  renderWithToken(token, {
    repoData
  }) {
    if (!token || token === _keytarStrategy.UNAUTHENTICATED || token === _keytarStrategy.INSUFFICIENT || token instanceof Error) {
      // we're not going to prompt users to log in to render decorations for comments
      // just let it go and move on with our lives.
      return null;
    }

    const head = repoData.branches.getHeadBranch();

    if (!head.isPresent()) {
      return null;
    }

    const push = head.getPush();

    if (!push.isPresent() || !push.isRemoteTracking()) {
      return null;
    }

    const pushRemote = repoData.remotes.withName(push.getRemoteName());

    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return null;
    }

    const endpoint = repoData.currentRemote.getEndpoint();

    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/commentDecorationsContainerQuery.graphql");

      if (node.hash && node.hash !== "8154acbf4c24d190f6fdf0254ae73817") {
        console.error("The definition of 'commentDecorationsContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/commentDecorationsContainerQuery.graphql");
    });

    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: 1,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    };
    return _react["default"].createElement(_relayEnvironment["default"].Provider, {
      value: environment
    }, _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithPullRequest(_objectSpread2({
        endpoint,
        owner: variables.headOwner,
        repo: variables.headName
      }, queryResult), {
        repoData,
        token
      })
    }));
  }

  renderWithPullRequest({
    error,
    props,
    endpoint,
    owner,
    repo
  }, {
    repoData,
    token
  }) {
    if (error) {
      // eslint-disable-next-line no-console
      console.warn(`error fetching CommentDecorationsContainer data: ${error}`);
      return null;
    }

    if (!props || !props.repository || !props.repository.ref || props.repository.ref.associatedPullRequests.totalCount === 0) {
      // no loading spinner for you
      // just fetch silently behind the scenes like a good little container
      return null;
    }

    const currentPullRequest = props.repository.ref.associatedPullRequests.nodes[0];
    return _react["default"].createElement(_aggregatedReviewsContainer["default"], {
      pullRequest: currentPullRequest,
      reportRelayError: this.props.reportRelayError
    }, ({
      errors,
      summaries,
      commentThreads
    }) => {
      return this.renderWithReviews({
        errors,
        summaries,
        commentThreads
      }, {
        currentPullRequest,
        repoResult: props,
        endpoint,
        owner,
        repo,
        repoData,
        token
      });
    });
  }

  renderWithReviews({
    errors,
    summaries,
    commentThreads
  }, {
    currentPullRequest,
    repoResult,
    endpoint,
    owner,
    repo,
    repoData,
    token
  }) {
    if (errors && errors.length > 0) {
      // eslint-disable-next-line no-console
      console.warn('Errors aggregating reviews and comments for current pull request', ...errors);
      return null;
    }

    if (commentThreads.length === 0) {
      return null;
    }

    return _react["default"].createElement(_prPatchContainer["default"], {
      owner: owner,
      repo: repo,
      number: currentPullRequest.number,
      endpoint: endpoint,
      token: token,
      largeDiffThreshold: Infinity
    }, (patchError, patch) => this.renderWithPatch({
      error: patchError,
      patch
    }, {
      summaries,
      commentThreads,
      currentPullRequest,
      repoResult,
      endpoint,
      owner,
      repo,
      repoData,
      token
    }));
  }

  renderWithPatch({
    error,
    patch
  }, {
    summaries,
    commentThreads,
    currentPullRequest,
    repoResult,
    endpoint,
    owner,
    repo,
    repoData,
    token
  }) {
    if (error) {
      // eslint-disable-next-line no-console
      console.warn('Error fetching patch for current pull request', error);
      return null;
    }

    if (!patch) {
      return null;
    }

    return _react["default"].createElement(_commentPositioningContainer["default"], {
      multiFilePatch: patch,
      commentThreads: commentThreads,
      prCommitSha: currentPullRequest.headRefOid,
      localRepository: this.props.localRepository,
      workdir: repoData.workingDirectoryPath
    }, commentTranslations => {
      if (!commentTranslations) {
        return null;
      }

      return _react["default"].createElement(_commentDecorationsController["default"], {
        endpoint: endpoint,
        owner: owner,
        repo: repo,
        workspace: this.props.workspace,
        commands: this.props.commands,
        repoData: repoData,
        commentThreads: commentThreads,
        commentTranslations: commentTranslations,
        pullRequests: repoResult.repository.ref.associatedPullRequests.nodes
      });
    });
  }

}

exports["default"] = CommentDecorationsContainer;

_defineProperty(CommentDecorationsContainer, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  localRepository: _propTypes["default"].object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  reportRelayError: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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