"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _atomTextEditor = require("./atom-text-editor");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const gutterProps = {
  name: _propTypes["default"].string.isRequired,
  priority: _propTypes["default"].number.isRequired,
  visible: _propTypes["default"].bool,
  type: _propTypes["default"].oneOf(['line-number', 'decorated']),
  labelFn: _propTypes["default"].func,
  onMouseDown: _propTypes["default"].func,
  onMouseMove: _propTypes["default"].func
};

class BareGutter extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'observeEditor', 'forceUpdate');
    this.state = {
      gutter: null
    };
    this.sub = new _eventKit.Disposable();
  }

  componentDidMount() {
    this.sub = this.props.editorHolder.observe(this.observeEditor);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.sub.dispose();
      this.sub = this.props.editorHolder.observe(this.observeEditor);
    }
  }

  componentWillUnmount() {
    if (this.state.gutter !== null) {
      try {
        this.state.gutter.destroy();
      } catch (e) {// Gutter already destroyed. Disregard.
      }
    }

    this.sub.dispose();
  }

  render() {
    return null;
  }

  observeEditor(editor) {
    this.setState((prevState, props) => {
      if (prevState.gutter !== null) {
        prevState.gutter.destroy();
      }

      const options = (0, _helpers.extractProps)(props, gutterProps);
      options["class"] = props.className;
      return {
        gutter: editor.addGutter(options)
      };
    });
  }

}

_defineProperty(BareGutter, "propTypes", _objectSpread2({
  editorHolder: _propTypes2.RefHolderPropType.isRequired,
  className: _propTypes["default"].string
}, gutterProps));

_defineProperty(BareGutter, "defaultProps", {
  visible: true,
  type: 'decorated',
  labelFn: () => {}
});

class Gutter extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.state = {
      editorHolder: _refHolder["default"].on(this.props.editor)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    return editorChanged ? _refHolder["default"].on(props.editor) : null;
  }

  render() {
    if (!this.state.editorHolder.isEmpty()) {
      return _react["default"].createElement(BareGutter, _extends({}, this.props, {
        editorHolder: this.state.editorHolder
      }));
    }

    return _react["default"].createElement(_atomTextEditor.TextEditorContext.Consumer, null, editorHolder => _react["default"].createElement(BareGutter, _extends({}, this.props, {
      editorHolder: editorHolder
    })));
  }

}

exports["default"] = Gutter;

_defineProperty(Gutter, "propTypes", {
  editor: _propTypes["default"].object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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