Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _stackTrace = require('stack-trace');

var _stackTrace2 = _interopRequireDefault(_stackTrace);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var API_KEY = '7ddca14cb60cbd1cd12d1b252473b076';
var LIB_VERSION = require('../package.json')['version'];
var StackTraceCache = new WeakMap();

var Reporter = (function () {
  function Reporter() {
    var params = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, Reporter);

    this.request = params.request || window.fetch;
    this.alwaysReport = params.hasOwnProperty('alwaysReport') ? params.alwaysReport : false;
    this.reportPreviousErrors = params.hasOwnProperty('reportPreviousErrors') ? params.reportPreviousErrors : true;
    this.resourcePath = this.normalizePath(params.resourcePath || process.resourcesPath);
    this.reportedErrors = [];
    this.reportedAssertionFailures = [];
  }

  _createClass(Reporter, [{
    key: 'buildNotificationJSON',
    value: function buildNotificationJSON(error, params) {
      return {
        apiKey: API_KEY,
        notifier: {
          name: 'Atom',
          version: LIB_VERSION,
          url: 'https://www.atom.io'
        },
        events: [{
          payloadVersion: '2',
          exceptions: [this.buildExceptionJSON(error, params.projectRoot)],
          severity: params.severity,
          user: {
            id: params.userId
          },
          app: {
            version: params.appVersion,
            releaseStage: params.releaseStage
          },
          device: {
            osVersion: params.osVersion
          },
          metaData: error.metadata
        }]
      };
    }
  }, {
    key: 'buildExceptionJSON',
    value: function buildExceptionJSON(error, projectRoot) {
      return {
        errorClass: error.constructor.name,
        message: error.message,
        stacktrace: this.buildStackTraceJSON(error, projectRoot)
      };
    }
  }, {
    key: 'buildStackTraceJSON',
    value: function buildStackTraceJSON(error, projectRoot) {
      var _this = this;

      return this.parseStackTrace(error).map(function (callSite) {
        return {
          file: _this.scrubPath(callSite.getFileName()),
          method: callSite.getMethodName() || callSite.getFunctionName() || 'none',
          lineNumber: callSite.getLineNumber(),
          columnNumber: callSite.getColumnNumber(),
          inProject: !/node_modules/.test(callSite.getFileName())
        };
      });
    }
  }, {
    key: 'normalizePath',
    value: function normalizePath(pathToNormalize) {
      return pathToNormalize.replace('file:///', '') // Sometimes it's a uri
      .replace(/\\/g, '/'); // Unify path separators across Win/macOS/Linux
    }
  }, {
    key: 'scrubPath',
    value: function scrubPath(pathToScrub) {
      var absolutePath = this.normalizePath(pathToScrub);

      if (this.isBundledFile(absolutePath)) {
        return this.normalizePath(_path2['default'].relative(this.resourcePath, absolutePath));
      } else {
        return absolutePath.replace(this.normalizePath(_fsPlus2['default'].getHomeDirectory()), '~') // Remove users home dir
        .replace(/.*(\/packages\/.*)/, '$1'); // Remove everything before app.asar or packages
      }
    }
  }, {
    key: 'getDefaultNotificationParams',
    value: function getDefaultNotificationParams() {
      return {
        userId: atom.config.get('exception-reporting.userId'),
        appVersion: atom.getVersion(),
        releaseStage: this.getReleaseChannel(atom.getVersion()),
        projectRoot: atom.getLoadSettings().resourcePath,
        osVersion: _os2['default'].platform() + '-' + _os2['default'].arch() + '-' + _os2['default'].release()
      };
    }
  }, {
    key: 'getReleaseChannel',
    value: function getReleaseChannel(version) {
      return version.indexOf('beta') > -1 ? 'beta' : version.indexOf('dev') > -1 ? 'dev' : 'stable';
    }
  }, {
    key: 'performRequest',
    value: function performRequest(json) {
      this.request.call(null, 'https://notify.bugsnag.com', {
        method: 'POST',
        headers: new Headers({ 'Content-Type': 'application/json' }),
        body: JSON.stringify(json)
      });
    }
  }, {
    key: 'shouldReport',
    value: function shouldReport(error) {
      if (this.alwaysReport) return true; // Used in specs
      if (atom.config.get('core.telemetryConsent') !== 'limited') return false;
      if (atom.inDevMode()) return false;

      var topFrame = this.parseStackTrace(error)[0];
      var fileName = topFrame ? topFrame.getFileName() : null;
      return fileName && (this.isBundledFile(fileName) || this.isTeletypeFile(fileName));
    }
  }, {
    key: 'parseStackTrace',
    value: function parseStackTrace(error) {
      var callSites = StackTraceCache.get(error);
      if (callSites) {
        return callSites;
      } else {
        callSites = _stackTrace2['default'].parse(error);
        StackTraceCache.set(error, callSites);
        return callSites;
      }
    }
  }, {
    key: 'requestPrivateMetadataConsent',
    value: function requestPrivateMetadataConsent(error, message, reportFn) {
      var notification = undefined,
          dismissSubscription = undefined;

      function reportWithoutPrivateMetadata() {
        if (dismissSubscription) {
          dismissSubscription.dispose();
        }
        delete error.privateMetadata;
        delete error.privateMetadataDescription;
        reportFn(error);
        if (notification) {
          notification.dismiss();
        }
      }

      function reportWithPrivateMetadata() {
        if (error.metadata == null) {
          error.metadata = {};
        }
        for (var key in error.privateMetadata) {
          var value = error.privateMetadata[key];
          error.metadata[key] = value;
        }
        reportWithoutPrivateMetadata();
      }

      var name = error.privateMetadataRequestName;
      if (name != null) {
        if (localStorage.getItem('private-metadata-request:' + name)) {
          return reportWithoutPrivateMetadata(error);
        } else {
          localStorage.setItem('private-metadata-request:' + name, true);
        }
      }

      notification = atom.notifications.addInfo(message, {
        detail: error.privateMetadataDescription,
        description: 'Are you willing to submit this information to a private server for debugging purposes?',
        dismissable: true,
        buttons: [{
          text: 'No',
          onDidClick: reportWithoutPrivateMetadata
        }, {
          text: 'Yes, Submit for Debugging',
          onDidClick: reportWithPrivateMetadata
        }]
      });

      dismissSubscription = notification.onDidDismiss(reportWithoutPrivateMetadata);
    }
  }, {
    key: 'addPackageMetadata',
    value: function addPackageMetadata(error) {
      var activePackages = atom.packages.getActivePackages();
      var availablePackagePaths = atom.packages.getPackageDirPaths();
      if (activePackages.length > 0) {
        var userPackages = {};
        var bundledPackages = {};
        for (var pack of atom.packages.getActivePackages()) {
          if (availablePackagePaths.includes(_path2['default'].dirname(pack.path))) {
            userPackages[pack.name] = pack.metadata.version;
          } else {
            bundledPackages[pack.name] = pack.metadata.version;
          }
        }

        if (error.metadata == null) {
          error.metadata = {};
        }
        error.metadata.bundledPackages = bundledPackages;
        error.metadata.userPackages = userPackages;
      }
    }
  }, {
    key: 'addPreviousErrorsMetadata',
    value: function addPreviousErrorsMetadata(error) {
      if (!this.reportPreviousErrors) return;
      if (!error.metadata) error.metadata = {};
      error.metadata.previousErrors = this.reportedErrors.map(function (error) {
        return error.message;
      });
      error.metadata.previousAssertionFailures = this.reportedAssertionFailures.map(function (error) {
        return error.message;
      });
    }
  }, {
    key: 'reportUncaughtException',
    value: function reportUncaughtException(error) {
      var _this2 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, 'The Atom team would like to collect the following information to resolve this error:', function (error) {
          return _this2.reportUncaughtException(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = 'error';
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedErrors.push(error);
    }
  }, {
    key: 'reportFailedAssertion',
    value: function reportFailedAssertion(error) {
      var _this3 = this;

      if (!this.shouldReport(error)) return;

      this.addPackageMetadata(error);
      this.addPreviousErrorsMetadata(error);

      if (error.privateMetadata != null && error.privateMetadataDescription != null) {
        this.requestPrivateMetadataConsent(error, 'The Atom team would like to collect some information to resolve an unexpected condition:', function (error) {
          return _this3.reportFailedAssertion(error);
        });
        return;
      }

      var params = this.getDefaultNotificationParams();
      params.severity = 'warning';
      this.performRequest(this.buildNotificationJSON(error, params));
      this.reportedAssertionFailures.push(error);
    }

    // Used in specs
  }, {
    key: 'setRequestFunction',
    value: function setRequestFunction(requestFunction) {
      this.request = requestFunction;
    }
  }, {
    key: 'isBundledFile',
    value: function isBundledFile(fileName) {
      return this.normalizePath(fileName).indexOf(this.resourcePath) === 0;
    }
  }, {
    key: 'isTeletypeFile',
    value: function isTeletypeFile(fileName) {
      var teletypePath = atom.packages.resolvePackagePath('teletype');
      return teletypePath && this.normalizePath(fileName).indexOf(teletypePath) === 0;
    }
  }]);

  return Reporter;
})();

exports['default'] = Reporter;

Reporter.API_KEY = API_KEY;
Reporter.LIB_VERSION = LIB_VERSION;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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