(function() {
  var PropertiesURL, fetch, filterExcerpt, fs, mdnCSSURL, mdnJSONAPI, path, request;

  path = require('path');

  fs = require('fs');

  request = require('request');

  mdnCSSURL = 'https://developer.mozilla.org/en-US/docs/Web/CSS';

  mdnJSONAPI = 'https://developer.mozilla.org/en-US/search.json?topic=css&highlight=false';

  PropertiesURL = 'https://raw.githubusercontent.com/adobe/brackets/master/src/extensions/default/CSSCodeHints/CSSProperties.json';

  fetch = function() {
    var propertiesPromise;
    propertiesPromise = new Promise(function(resolve) {
      return request({
        json: true,
        url: PropertiesURL
      }, function(error, response, properties) {
        if (error != null) {
          console.error(error.message);
          resolve(null);
        }
        if (response.statusCode !== 200) {
          console.error("Request for CSSProperties.json failed: " + response.statusCode);
          resolve(null);
        }
        return resolve(properties);
      });
    });
    return propertiesPromise.then(function(properties) {
      var MAX, docs, queue, running;
      if (properties == null) {
        return;
      }
      MAX = 10;
      queue = Object.keys(properties);
      running = [];
      docs = {};
      return new Promise(function(resolve) {
        var checkEnd, handleRequest, i, ref, removeRunning, run, runNext;
        checkEnd = function() {
          if (queue.length === 0 && running.length === 0) {
            return resolve(docs);
          }
        };
        removeRunning = function(propertyName) {
          var index;
          index = running.indexOf(propertyName);
          if (index > -1) {
            return running.splice(index, 1);
          }
        };
        runNext = function() {
          var propertyName;
          checkEnd();
          if (queue.length !== 0) {
            propertyName = queue.pop();
            running.push(propertyName);
            return run(propertyName);
          }
        };
        run = function(propertyName) {
          var url;
          url = mdnJSONAPI + "&q=" + propertyName;
          return request({
            json: true,
            url: url
          }, function(error, response, searchResults) {
            if ((error == null) && response.statusCode === 200) {
              handleRequest(propertyName, searchResults);
            } else {
              console.error("Req failed " + url + "; " + response.statusCode + ", " + error);
            }
            removeRunning(propertyName);
            checkEnd();
            return runNext();
          });
        };
        handleRequest = function(propertyName, searchResults) {
          var doc, i, len, ref;
          if (searchResults.documents != null) {
            ref = searchResults.documents;
            for (i = 0, len = ref.length; i < len; i++) {
              doc = ref[i];
              if (doc.url === (mdnCSSURL + "/" + propertyName)) {
                docs[propertyName] = filterExcerpt(propertyName, doc.excerpt);
                break;
              }
            }
          }
        };
        for (i = 0, ref = MAX; 0 <= ref ? i <= ref : i >= ref; 0 <= ref ? i++ : i--) {
          runNext();
        }
      });
    });
  };

  filterExcerpt = function(propertyName, excerpt) {
    var beginningPattern, periodIndex;
    beginningPattern = /^the (css )?[a-z-]+ (css )?property (is )?(\w+)/i;
    excerpt = excerpt.replace(beginningPattern, function(match) {
      var firstWord, matches;
      matches = beginningPattern.exec(match);
      firstWord = matches[4];
      return firstWord[0].toUpperCase() + firstWord.slice(1);
    });
    periodIndex = excerpt.indexOf('.');
    if (periodIndex > -1) {
      excerpt = excerpt.slice(0, periodIndex + 1);
    }
    return excerpt;
  };

  if (require.main === module) {
    fetch().then(function(docs) {
      if (docs != null) {
        return fs.writeFileSync(path.join(__dirname, 'property-docs.json'), (JSON.stringify(docs, null, '  ')) + "\n");
      } else {
        return console.error('No docs');
      }
    });
  }

  module.exports = fetch;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
