/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.merge;

import java.util.List;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.NodeMergeAlgorithm;
import org.openoffice.xmerge.merger.diff.CharArrayLCSAlgorithm;
import org.openoffice.xmerge.merger.diff.CharacterParser;
import org.openoffice.xmerge.merger.diff.TextNodeEntry;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Node;

public final class CharacterBaseParagraphMerge
implements NodeMergeAlgorithm {
    @Override
    public void merge(Node orgPara, Node modPara) {
        CharacterParser orgParser = new CharacterParser(orgPara);
        CharacterParser modParser = new CharacterParser(modPara);
        char[] orgCharArray = orgParser.getCharArray();
        char[] modCharArray = modParser.getCharArray();
        CharArrayLCSAlgorithm diffAlgo = new CharArrayLCSAlgorithm();
        Difference[] diffResult = diffAlgo.computeDiffs(orgCharArray, modCharArray);
        System.out.println("Diff Result: ");
        for (int i = 0; i < diffResult.length; ++i) {
            Debug.log(1, diffResult[i].debug());
        }
        this.applyDifference(orgParser, modParser, diffResult);
    }

    private void applyDifference(CharacterParser orgParser, CharacterParser modParser, Difference[] diffs) {
        List<TextNodeEntry> orgNodeList = orgParser.getNodeList();
        int diffCount = 0;
        int numNode = orgNodeList.size();
        for (int i = 0; i < numNode; ++i) {
            int extraChar = 0;
            int orgDiffCount = diffCount;
            TextNodeEntry orgTextNode = orgNodeList.get(i);
            Debug.log(1, "checking node " + (i + 1) + " of " + numNode);
            while (diffCount < diffs.length) {
                Debug.log(1, "  checking diff " + (diffCount + 1) + " of " + diffs.length);
                Debug.log(1, "    OrgPosision <" + diffs[diffCount].getOrgPosition() + "> diffCount <" + diffCount + "> orgDiffCount <" + orgDiffCount + ">");
                if (diffs[diffCount].getOrgPosition() > orgTextNode.endChar() && i < numNode - 1) {
                    Debug.log(1, "    breaking!");
                    break;
                }
                if (diffs[diffCount].getOrgPosition() >= orgTextNode.startChar()) {
                    if (diffs[diffCount].getOperation() == 2) {
                        --extraChar;
                    } else if (diffs[diffCount].getOperation() == 1) {
                        ++extraChar;
                    }
                }
                ++diffCount;
            }
            Debug.log(1, "  final diffCount <" + diffCount + "> final orgDiffCount <" + orgDiffCount + ">");
            if (diffCount <= orgDiffCount) continue;
            Debug.log(1, "  There is a difference, doing merge");
            Debug.log(1, "  TextNode name <" + orgTextNode.node().getNodeName() + ">");
            Debug.log(1, "  TextNode value <" + orgTextNode.node().getNodeValue() + ">");
            Debug.log(1, "  TextNode start char <" + orgTextNode.startChar() + "> TextNode end char <" + orgTextNode.endChar() + ">");
            Debug.log(1, "  extraChar value <" + extraChar + ">");
            this.coreMerge(orgDiffCount, diffCount, diffs, modParser, orgTextNode, extraChar);
        }
    }

    private void coreMerge(int startDiffNum, int endDiffNum, Difference[] diffs, CharacterParser modParser, TextNodeEntry orgTextNode, int extraChar) {
        int orgStartPosition;
        Node orgNode = orgTextNode.node();
        char[] modTextArray = modParser.getCharArray();
        String tmpString = orgNode.getNodeValue() != null ? orgNode.getNodeValue() : "";
        char[] orgNodeText = tmpString.toCharArray();
        char[] newNodeText = orgNodeText.length + extraChar > 0 ? new char[orgNodeText.length + extraChar] : new char[]{};
        int orgTextPosition = orgTextNode.startChar();
        int newTextPosition = 0;
        int unChangedTextLength = 0;
        char[] cacheCharArray = new char[endDiffNum - startDiffNum];
        int cacheLength = 0;
        int lastDiffOperation = 4;
        int lastDiffPosition = -1;
        for (int j = startDiffNum; j < endDiffNum; ++j) {
            if (diffs[j].getOrgPosition() > orgTextPosition) {
                if (cacheLength > 0) {
                    System.arraycopy(cacheCharArray, 0, newNodeText, newTextPosition, cacheLength);
                    newTextPosition += cacheLength;
                    lastDiffPosition = -1;
                    lastDiffOperation = 4;
                    cacheLength = 0;
                }
                unChangedTextLength = diffs[j].getOrgPosition() - orgTextPosition;
                System.arraycopy(orgNodeText, orgTextPosition - orgTextNode.startChar(), newNodeText, newTextPosition, unChangedTextLength);
                orgTextPosition += unChangedTextLength;
                newTextPosition += unChangedTextLength;
            }
            if (diffs[j].getOperation() == 2) {
                ++orgTextPosition;
                if (cacheLength <= 0) continue;
                System.arraycopy(cacheCharArray, 0, newNodeText, newTextPosition, cacheLength);
                newTextPosition += cacheLength;
                lastDiffPosition = -1;
                lastDiffOperation = 4;
                cacheLength = 0;
                continue;
            }
            if ((lastDiffOperation != diffs[j].getOperation() || diffs[j].getOperation() == 3 && diffs[j].getOrgPosition() != lastDiffPosition + 1 || diffs[j].getOperation() == 1 && diffs[j].getOrgPosition() != lastDiffPosition) && cacheLength > 0) {
                System.arraycopy(cacheCharArray, 0, newNodeText, newTextPosition, cacheLength);
                newTextPosition += cacheLength;
                cacheLength = 0;
            }
            cacheCharArray[cacheLength] = modTextArray[diffs[j].getModPosition()];
            ++cacheLength;
            lastDiffOperation = diffs[j].getOperation();
            lastDiffPosition = diffs[j].getOrgPosition();
            if (lastDiffOperation != 3) continue;
            ++orgTextPosition;
        }
        if (cacheLength > 0) {
            System.arraycopy(cacheCharArray, 0, newNodeText, newTextPosition, cacheLength);
            newTextPosition += cacheLength;
        }
        if (orgNodeText.length + (orgStartPosition = orgTextNode.startChar()) > orgTextPosition) {
            unChangedTextLength = orgNodeText.length + orgStartPosition - orgTextPosition;
            System.arraycopy(orgNodeText, orgTextPosition - orgStartPosition, newNodeText, newTextPosition, unChangedTextLength);
        }
        if (endDiffNum > startDiffNum) {
            String newString = new String(newNodeText);
            orgNode.setNodeValue(newString);
        }
    }
}

