#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: easytest
version: 0.2.1
id: easytest-0.2.1-FrR09Heuc1g9rMebQrdKU0
key: easytest-0.2.1-FrR09Heuc1g9rMebQrdKU0
license: MIT
copyright: Copyright (C) 2017-2018 Joel Burget, Copyright (C) 2016 Paul Chiusano and contributors
maintainer: Joel Burget <joelburget@gmail.com>
author: Joel Burget, Paul Chiusano
stability: provisional
homepage: https://github.com/joelburget/easytest
synopsis: Simple, expressive testing library
description:
    EasyTest is a simple testing toolkit, meant to replace most uses of QuickCheck, SmallCheck, HUnit, and frameworks like Tasty, etc. Here'\''s an example usage:
    .
    > module Main where
    >
    > import EasyTest
    > import Control.Applicative
    > import Control.Monad
    >
    > suite :: Test ()
    > suite = tests
    >   [ scope "addition.ex1" $ expect (1 + 1 == 2)
    >   , scope "addition.ex2" $ expect (2 + 3 == 5)
    >   , scope "list.reversal" . fork $ do
    >       -- generate lists from size 0 to 10, of Ints in (0,43)
    >       -- shorthand: listsOf [0..10] (int'\'' 0 43)
    >       ns <- [0..10] `forM` \n -> replicateM n (int'\'' 0 43)
    >       ns `forM_` \ns -> expect (reverse (reverse ns) == ns)
    >   -- equivalent to `scope "addition.ex3"`
    >   , scope "addition" . scope "ex3" $ expect (3 + 3 == 6)
    >   , scope "always passes" $ do
    >       note "I'\''m running this test, even though it always passes!"
    >       ok -- like `pure ()`, but records a success result
    >   , scope "failing test" $ crash "oh noes!!" ]
    >
    > -- NB: `run suite` would run all tests, but we only run
    > -- tests whose scopes are prefixed by "addition"
    > main = runOnly "addition" suite
    .
    This generates the output:
    .
    > Randomness seed for this run is 5104092164859451056
    > Raw test output to follow ...
    > ------------------------------------------------------------
    > OK addition.ex1
    > OK addition.ex2
    > OK addition.ex3
    > ------------------------------------------------------------
    > ✅  3 tests passed, no failures! 👍 🎉
    The idea here is to write tests with ordinary Haskell code, with control flow explicit and under programmer control.
category: Testing
abi: c2407117afeaedd35c3718a1b4f450c9
exposed: True
exposed-modules:
    EasyTest EasyTest.Internal
hidden-modules: EasyTest.Generators EasyTest.Porcelain
import-dirs: /usr/lib/ghc-8.6.5/site-local/easytest-0.2.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/easytest-0.2.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/easytest-0.2.1
hs-libraries: HSeasytest-0.2.1-FrR09Heuc1g9rMebQrdKU0
depends:
    async-2.2.2-5KbUJa8fnnu9oaTmXcEjsG base-4.12.0.0
    call-stack-0.2.0-7WtbHJpXoU7ImWgyG0WuEu containers-0.6.0.1
    mtl-2.2.2 random-1.1-3ypV4EIycgb35PKjTYYr5q stm-2.5.0.0
    text-1.2.3.1 transformers-0.5.6.2
haddock-interfaces: /usr/share/doc/haskell-easytest/html/easytest.haddock
haddock-html: /usr/share/doc/haskell-easytest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

