//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.3
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceStorm;

/**
 * A topic manager manages topics, and subscribers to topics.
 *
 * @see Topic
 **/
public interface TopicManagerPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @return A proxy to the topic instance.
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     **/
    default TopicPrx create(String name)
        throws TopicExists
    {
        return create(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     **/
    default TopicPrx create(String name, java.util.Map<String, String> context)
        throws TopicExists
    {
        try
        {
            return _iceI_createAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(TopicExists ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @return A proxy to the topic instance.
     **/
    default java.util.concurrent.CompletableFuture<TopicPrx> createAsync(String name)
    {
        return _iceI_createAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Create a new topic. The topic name must be unique.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     **/
    default java.util.concurrent.CompletableFuture<TopicPrx> createAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_createAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<TopicPrx> _iceI_createAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<TopicPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "create", null, sync, _iceE_create);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     TopicPrx ret;
                     ret = TopicPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_create =
    {
        TopicExists.class
    };

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @return A proxy to the topic instance.
     * @throws NoSuchTopic Raised if the topic does not exist.
     **/
    default TopicPrx retrieve(String name)
        throws NoSuchTopic
    {
        return retrieve(name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     * @throws NoSuchTopic Raised if the topic does not exist.
     **/
    default TopicPrx retrieve(String name, java.util.Map<String, String> context)
        throws NoSuchTopic
    {
        try
        {
            return _iceI_retrieveAsync(name, context, true).waitForResponseOrUserEx();
        }
        catch(NoSuchTopic ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @return A proxy to the topic instance.
     **/
    default java.util.concurrent.CompletableFuture<TopicPrx> retrieveAsync(String name)
    {
        return _iceI_retrieveAsync(name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Retrieve a topic by name.
     * @param name The name of the topic.
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     **/
    default java.util.concurrent.CompletableFuture<TopicPrx> retrieveAsync(String name, java.util.Map<String, String> context)
    {
        return _iceI_retrieveAsync(name, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<TopicPrx> _iceI_retrieveAsync(String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<TopicPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "retrieve", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_retrieve);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                 }, istr -> {
                     TopicPrx ret;
                     ret = TopicPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_retrieve =
    {
        NoSuchTopic.class
    };

    /**
     * Retrieve all topics managed by this topic manager.
     * @return A dictionary of string, topic proxy pairs.
     **/
    default java.util.Map<java.lang.String, TopicPrx> retrieveAll()
    {
        return retrieveAll(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @param context The Context map to send with the invocation.
     * @return A dictionary of string, topic proxy pairs.
     **/
    default java.util.Map<java.lang.String, TopicPrx> retrieveAll(java.util.Map<String, String> context)
    {
        return _iceI_retrieveAllAsync(context, true).waitForResponse();
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @return A dictionary of string, topic proxy pairs.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, TopicPrx>> retrieveAllAsync()
    {
        return _iceI_retrieveAllAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Retrieve all topics managed by this topic manager.
     * @param context The Context map to send with the invocation.
     * @return A dictionary of string, topic proxy pairs.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, TopicPrx>> retrieveAllAsync(java.util.Map<String, String> context)
    {
        return _iceI_retrieveAllAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, TopicPrx>> _iceI_retrieveAllAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, TopicPrx>> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "retrieveAll", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     java.util.Map<java.lang.String, TopicPrx> ret;
                     ret = TopicDictHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.Map<java.lang.String, java.lang.String> getSliceChecksums()
    {
        return getSliceChecksums(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(java.util.Map<String, String> context)
    {
        return _iceI_getSliceChecksumsAsync(context, true).waitForResponse();
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, java.lang.String>> getSliceChecksumsAsync()
    {
        return _iceI_getSliceChecksumsAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    default java.util.concurrent.CompletableFuture<java.util.Map<java.lang.String, java.lang.String>> getSliceChecksumsAsync(java.util.Map<String, String> context)
    {
        return _iceI_getSliceChecksumsAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, java.lang.String>> _iceI_getSliceChecksumsAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.util.Map<java.lang.String, java.lang.String>> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getSliceChecksums", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     java.util.Map<java.lang.String, java.lang.String> ret;
                     ret = com.zeroc.Ice.SliceChecksumDictHelper.read(istr);
                     return ret;
                 });
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static TopicManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), TopicManagerPrx.class, _TopicManagerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static TopicManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), TopicManagerPrx.class, _TopicManagerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static TopicManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), TopicManagerPrx.class, _TopicManagerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static TopicManagerPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), TopicManagerPrx.class, _TopicManagerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static TopicManagerPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, TopicManagerPrx.class, _TopicManagerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static TopicManagerPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, TopicManagerPrx.class, _TopicManagerPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default TopicManagerPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (TopicManagerPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default TopicManagerPrx ice_adapterId(String newAdapterId)
    {
        return (TopicManagerPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default TopicManagerPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (TopicManagerPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default TopicManagerPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (TopicManagerPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default TopicManagerPrx ice_invocationTimeout(int newTimeout)
    {
        return (TopicManagerPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default TopicManagerPrx ice_connectionCached(boolean newCache)
    {
        return (TopicManagerPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default TopicManagerPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (TopicManagerPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default TopicManagerPrx ice_secure(boolean b)
    {
        return (TopicManagerPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default TopicManagerPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (TopicManagerPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default TopicManagerPrx ice_preferSecure(boolean b)
    {
        return (TopicManagerPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default TopicManagerPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (TopicManagerPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default TopicManagerPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (TopicManagerPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default TopicManagerPrx ice_collocationOptimized(boolean b)
    {
        return (TopicManagerPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default TopicManagerPrx ice_twoway()
    {
        return (TopicManagerPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default TopicManagerPrx ice_oneway()
    {
        return (TopicManagerPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default TopicManagerPrx ice_batchOneway()
    {
        return (TopicManagerPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default TopicManagerPrx ice_datagram()
    {
        return (TopicManagerPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default TopicManagerPrx ice_batchDatagram()
    {
        return (TopicManagerPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default TopicManagerPrx ice_compress(boolean co)
    {
        return (TopicManagerPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default TopicManagerPrx ice_timeout(int t)
    {
        return (TopicManagerPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default TopicManagerPrx ice_connectionId(String connectionId)
    {
        return (TopicManagerPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default TopicManagerPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (TopicManagerPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceStorm::TopicManager";
    }
}
