/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class KeyboardParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(KeyboardParam.class);
    private static final String KEYBOARD_BASE_KEY = "keyboard";
    private static final String ALL_SHORTCUTS_KEY = "keyboard.shortcuts";
    private static final String MENU_ITEM_KEY = "menu";
    private static final String KEYCODE_KEY = "keycode";
    private static final String MODIFIERS_KEY = "modifiers";
    private Map<String, KeyStroke> map = null;

    @Override
    protected void parse() {
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_SHORTCUTS_KEY);
            this.map = new HashMap<String, KeyStroke>(fields.size());
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(MENU_ITEM_KEY, "");
                if (name.length() <= 0) continue;
                this.map.put(name, KeyStroke.getKeyStroke(sub.getInt(KEYCODE_KEY, 0), sub.getInt(MODIFIERS_KEY, 0), false));
            }
        }
        catch (ConversionException e) {
            logger.error((Object)("Error while loading keyboard shortcuts " + e.getMessage()), (Throwable)e);
        }
    }

    public KeyStroke getShortcut(String i18nKey) {
        return this.map.get(i18nKey);
    }

    public void setShortcut(String i18nKey, KeyStroke keyStroke) {
        this.map.put(i18nKey, keyStroke);
    }

    protected void setConfigs() {
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_SHORTCUTS_KEY);
        int i = 0;
        for (Map.Entry<String, KeyStroke> entry : this.map.entrySet()) {
            String elementBaseKey = "keyboard.shortcuts(" + i + ").";
            this.getConfig().setProperty(elementBaseKey + MENU_ITEM_KEY, (Object)entry.getKey());
            if (entry.getValue() != null) {
                this.getConfig().setProperty(elementBaseKey + KEYCODE_KEY, (Object)entry.getValue().getKeyCode());
                this.getConfig().setProperty(elementBaseKey + MODIFIERS_KEY, (Object)entry.getValue().getModifiers());
            } else {
                this.getConfig().setProperty(elementBaseKey + KEYCODE_KEY, (Object)0);
                this.getConfig().setProperty(elementBaseKey + MODIFIERS_KEY, (Object)0);
            }
            ++i;
        }
    }
}

