
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * FileSeekOrigin.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
What a file seek ({@link org.virtualbox_6_1.IFile#seek(Long,org.virtualbox_6_1.FileSeekOrigin)}) is relative to.
Interface ID: <tt>{AD32F789-4279-4530-979C-F16892E1C263}</tt>
*/
public enum FileSeekOrigin
{

/**
Seek from the beginning of the file.
*/
    Begin(0),

/**
Seek from the current file position.
*/
    Current(1),

/**
Seek relative to the end of the file.  To seek to the position two
bytes from the end of the file, specify -2 as the seek offset.
*/
    End(2);

    private final int value;

    FileSeekOrigin(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static FileSeekOrigin fromValue(long v)
    {
        for (FileSeekOrigin c: FileSeekOrigin.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static FileSeekOrigin fromValue(String v)
    {
        return valueOf(FileSeekOrigin.class, v);
    }
}

