/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Iterator;

public class TreeMarshaller
implements MarshallingContext {
    protected HierarchicalStreamWriter writer;
    protected ConverterLookup converterLookup;
    protected ClassMapper classMapper;
    private ObjectIdDictionary parentObjects = new ObjectIdDictionary();
    private DataHolder dataHolder;
    static /* synthetic */ Class class$com$thoughtworks$xstream$alias$ClassMapper$Null;

    public TreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, ClassMapper classMapper) {
        this.writer = writer;
        this.converterLookup = converterLookup;
        this.classMapper = classMapper;
    }

    public void convertAnother(Object item) {
        if (this.parentObjects.containsId(item)) {
            throw new CircularReferenceException();
        }
        this.parentObjects.associateId(item, "");
        Converter converter = this.converterLookup.lookupConverterForType(item.getClass());
        converter.marshal(item, this.writer, this);
        this.parentObjects.removeId(item);
    }

    public void start(Object item, DataHolder dataHolder) {
        this.dataHolder = dataHolder;
        if (item == null) {
            this.writer.startNode(this.classMapper.serializedClass(class$com$thoughtworks$xstream$alias$ClassMapper$Null == null ? (class$com$thoughtworks$xstream$alias$ClassMapper$Null = TreeMarshaller.class$("com.thoughtworks.xstream.alias.ClassMapper$Null")) : class$com$thoughtworks$xstream$alias$ClassMapper$Null));
            this.writer.endNode();
        } else {
            this.writer.startNode(this.classMapper.serializedClass(item.getClass()));
            this.convertAnother(item);
            this.writer.endNode();
        }
    }

    public Object get(Object key) {
        this.lazilyCreateDataHolder();
        return this.dataHolder.get(key);
    }

    public void put(Object key, Object value) {
        this.lazilyCreateDataHolder();
        this.dataHolder.put(key, value);
    }

    public Iterator keys() {
        this.lazilyCreateDataHolder();
        return this.dataHolder.keys();
    }

    private void lazilyCreateDataHolder() {
        if (this.dataHolder == null) {
            this.dataHolder = new MapBackedDataHolder();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CircularReferenceException
    extends RuntimeException {
    }
}

