/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import com.google.classpath.ClassPath;
import com.google.classpath.RegExpResourceFilter;
import com.google.classpath.ResourceFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.DefaultListModel;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import processing.app.Messages;
import processing.mode.java.JavaMode;
import processing.mode.java.pdex.CompletionCandidate;
import processing.mode.java.pdex.ImportStatement;
import processing.mode.java.pdex.PreprocessedSketch;
import processing.mode.java.pdex.SourceUtils;
import processing.mode.java.pdex.TextTransform;

public class CompletionGenerator {
    protected List<CompletionCandidate> candidates;
    protected String lastPredictedPhrase = " ";

    public static CompletionCandidate[] checkForTypes(ASTNode node) {
        List vdfs = null;
        switch (node.getNodeType()) {
            case 55: {
                return new CompletionCandidate[]{new CompletionCandidate((TypeDeclaration)node)};
            }
            case 31: {
                MethodDeclaration md = (MethodDeclaration)node;
                CompletionGenerator.log(CompletionGenerator.getNodeAsString((ASTNode)md));
                List params = (List)md.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.PARAMETERS_PROPERTY);
                CompletionCandidate[] cand = new CompletionCandidate[params.size() + 1];
                cand[0] = new CompletionCandidate(md);
                int i = 0;
                while (i < params.size()) {
                    cand[i + 1] = new CompletionCandidate((SingleVariableDeclaration)params.get(i));
                    ++i;
                }
                return cand;
            }
            case 44: {
                return new CompletionCandidate[]{new CompletionCandidate((SingleVariableDeclaration)node)};
            }
            case 23: {
                vdfs = ((FieldDeclaration)node).fragments();
                break;
            }
            case 60: {
                vdfs = ((VariableDeclarationStatement)node).fragments();
                break;
            }
            case 58: {
                vdfs = ((VariableDeclarationExpression)node).fragments();
                break;
            }
        }
        if (vdfs != null) {
            CompletionCandidate[] ret = new CompletionCandidate[vdfs.size()];
            int i = 0;
            for (VariableDeclarationFragment vdf : vdfs) {
                ret[i++] = new CompletionCandidate(vdf);
            }
            return ret;
        }
        return null;
    }

    public static ASTNode resolveExpression(ASTNode nearestNode, ASTNode expression, boolean noCompare) {
        CompletionGenerator.log("Resolving " + CompletionGenerator.getNodeAsString(expression) + " noComp " + noCompare);
        if (expression instanceof SimpleName) {
            return CompletionGenerator.findDeclaration2((Name)((SimpleName)expression), nearestNode);
        }
        if (expression instanceof MethodInvocation) {
            CompletionGenerator.log("3. Method Invo " + ((MethodInvocation)expression).getName());
            return CompletionGenerator.findDeclaration2((Name)((MethodInvocation)expression).getName(), nearestNode);
        }
        if (expression instanceof FieldAccess) {
            CompletionGenerator.log("2. Field access " + CompletionGenerator.getNodeAsString((ASTNode)((FieldAccess)expression).getExpression()) + "|||" + CompletionGenerator.getNodeAsString((ASTNode)((FieldAccess)expression).getName()));
            if (noCompare) {
                return CompletionGenerator.findDeclaration2((Name)((FieldAccess)expression).getName(), nearestNode);
            }
            return CompletionGenerator.resolveExpression(nearestNode, (ASTNode)((FieldAccess)expression).getExpression(), true);
        }
        if (expression instanceof QualifiedName) {
            CompletionGenerator.log("1. Resolving " + ((QualifiedName)expression).getQualifier() + " ||| " + ((QualifiedName)expression).getName());
            if (noCompare) {
                return CompletionGenerator.findDeclaration2((Name)((QualifiedName)expression).getName(), nearestNode);
            }
            return CompletionGenerator.findDeclaration2(((QualifiedName)expression).getQualifier(), nearestNode);
        }
        return null;
    }

    public static ClassMember resolveExpression3rdParty(PreprocessedSketch ps, ASTNode nearestNode, ASTNode astNode, boolean noCompare) {
        Class<?> tehClass;
        CompletionGenerator.log("Resolve 3rdParty expr-- " + CompletionGenerator.getNodeAsString(astNode) + " nearest node " + CompletionGenerator.getNodeAsString(nearestNode));
        if (astNode == null) {
            return null;
        }
        if (astNode instanceof SimpleName) {
            ASTNode decl = CompletionGenerator.findDeclaration2((Name)((SimpleName)astNode), nearestNode);
            if (decl != null) {
                CompletionGenerator.log(String.valueOf(CompletionGenerator.getNodeAsString(astNode)) + " found decl -> " + CompletionGenerator.getNodeAsString(decl));
                if (decl.getNodeType() == 55) {
                    TypeDeclaration td = (TypeDeclaration)decl;
                    return new ClassMember(ps, (ASTNode)td);
                }
                Type type = CompletionGenerator.extracTypeInfo2(decl);
                if (type != null && type.isArrayType() && astNode.getParent().getNodeType() != 2) {
                    Class<?> arrayClass;
                    Type elementType = ((ArrayType)type).getElementType();
                    String name = "";
                    if (elementType.isSimpleType()) {
                        Class<?> c = CompletionGenerator.findClassIfExists(ps, elementType.toString());
                        if (c != null) {
                            name = c.getName();
                        }
                    } else if (elementType.isPrimitiveType()) {
                        name = ((PrimitiveType)elementType).getPrimitiveTypeCode().toString();
                    }
                    return (arrayClass = CompletionGenerator.getArrayClass(name, ps.classLoader)) == null ? null : new ClassMember(arrayClass);
                }
                return new ClassMember(ps, (ASTNode)CompletionGenerator.extracTypeInfo(decl));
            }
            tehClass = CompletionGenerator.findClassIfExists(ps, astNode.toString());
            if (tehClass != null) {
                return new ClassMember(tehClass);
            }
            astNode = astNode.getParent();
        }
        switch (astNode.getNodeType()) {
            case 22: {
                ClassMember scopeParent;
                FieldAccess fa = (FieldAccess)astNode;
                if (fa.getExpression() == null) {
                    CompletionGenerator.log("FA,Not implemented.");
                    return null;
                }
                if (fa.getExpression() instanceof SimpleName) {
                    SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2((Name)((SimpleName)fa.getExpression()), nearestNode));
                    if (stp == null) {
                        tehClass = CompletionGenerator.findClassIfExists(ps, fa.getExpression().toString());
                        if (tehClass != null) {
                            return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(tehClass), fa.getName().toString());
                        }
                        CompletionGenerator.log("FA resolve 3rd par, Can't resolve " + fa.getExpression());
                        return null;
                    }
                    CompletionGenerator.log("FA, SN Type " + CompletionGenerator.getNodeAsString((ASTNode)stp));
                    scopeParent = CompletionGenerator.definedIn3rdPartyClass(ps, stp.getName().toString(), "THIS");
                } else {
                    scopeParent = CompletionGenerator.resolveExpression3rdParty(ps, nearestNode, (ASTNode)fa.getExpression(), noCompare);
                }
                CompletionGenerator.log("FA, ScopeParent " + scopeParent);
                return CompletionGenerator.definedIn3rdPartyClass(ps, scopeParent, fa.getName().toString());
            }
            case 32: {
                MethodInvocation mi = (MethodInvocation)astNode;
                ASTNode temp = CompletionGenerator.findDeclaration2((Name)mi.getName(), nearestNode);
                if (temp instanceof MethodDeclaration) {
                    CompletionGenerator.log(mi.getName() + " was found locally," + CompletionGenerator.getNodeAsString((ASTNode)CompletionGenerator.extracTypeInfo(temp)));
                    Type type = CompletionGenerator.extracTypeInfo2(temp);
                    if (type != null && type.isArrayType() && astNode.getParent().getNodeType() != 2) {
                        Class<?> arrayClass;
                        Type elementType = ((ArrayType)type).getElementType();
                        String name = "";
                        if (elementType.isSimpleType()) {
                            Class<?> c = CompletionGenerator.findClassIfExists(ps, elementType.toString());
                            if (c != null) {
                                name = c.getName();
                            }
                        } else if (elementType.isPrimitiveType()) {
                            name = ((PrimitiveType)elementType).getPrimitiveTypeCode().toString();
                        }
                        return (arrayClass = CompletionGenerator.getArrayClass(name, ps.classLoader)) == null ? null : new ClassMember(arrayClass);
                    }
                    return new ClassMember(ps, (ASTNode)CompletionGenerator.extracTypeInfo(temp));
                }
                if (mi.getExpression() == null) {
                    CompletionGenerator.log("MI,Not implemented.");
                    return null;
                }
                if (mi.getExpression() instanceof SimpleName) {
                    ASTNode decl = CompletionGenerator.findDeclaration2((Name)((SimpleName)mi.getExpression()), nearestNode);
                    if (decl == null) break;
                    if (decl.getNodeType() == 55) {
                        TypeDeclaration td = (TypeDeclaration)decl;
                        return new ClassMember(ps, (ASTNode)td);
                    }
                    SimpleType stp = CompletionGenerator.extracTypeInfo(decl);
                    if (stp == null) {
                        Class<?> tehClass2 = CompletionGenerator.findClassIfExists(ps, mi.getExpression().toString());
                        if (tehClass2 != null) {
                            return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(tehClass2), mi.getName().toString());
                        }
                        CompletionGenerator.log("MI resolve 3rd par, Can't resolve " + mi.getExpression());
                        return null;
                    }
                    CompletionGenerator.log("MI, SN Type " + CompletionGenerator.getNodeAsString((ASTNode)stp));
                    ASTNode typeDec = CompletionGenerator.findDeclaration2(stp.getName(), nearestNode);
                    if (typeDec == null) {
                        CompletionGenerator.log(stp.getName() + " couldn't be found locally..");
                        Class<?> tehClass3 = CompletionGenerator.findClassIfExists(ps, stp.getName().toString());
                        if (tehClass3 != null) {
                            return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(tehClass3), mi.getName().toString());
                        }
                    }
                    return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(ps, typeDec), mi.getName().toString());
                }
                CompletionGenerator.log("MI EXP.." + CompletionGenerator.getNodeAsString((ASTNode)mi.getExpression()));
                ClassMember scopeParent = CompletionGenerator.resolveExpression3rdParty(ps, nearestNode, (ASTNode)mi.getExpression(), noCompare);
                CompletionGenerator.log("MI, ScopeParent " + scopeParent);
                return CompletionGenerator.definedIn3rdPartyClass(ps, scopeParent, mi.getName().toString());
            }
            case 40: {
                QualifiedName qn = (QualifiedName)astNode;
                ASTNode temp2 = CompletionGenerator.findDeclaration2((Name)qn.getName(), nearestNode);
                if (temp2 instanceof FieldDeclaration) {
                    CompletionGenerator.log(qn.getName() + " was found locally," + CompletionGenerator.getNodeAsString((ASTNode)CompletionGenerator.extracTypeInfo(temp2)));
                    return new ClassMember(ps, (ASTNode)CompletionGenerator.extracTypeInfo(temp2));
                }
                if (qn.getQualifier() == null) {
                    CompletionGenerator.log("QN,Not implemented.");
                    return null;
                }
                if (qn.getQualifier() instanceof SimpleName) {
                    SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2(qn.getQualifier(), nearestNode));
                    if (stp == null) {
                        Class<?> tehClass4 = CompletionGenerator.findClassIfExists(ps, qn.getQualifier().toString());
                        if (tehClass4 != null) {
                            return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(tehClass4), qn.getName().toString());
                        }
                        CompletionGenerator.log("QN resolve 3rd par, Can't resolve " + qn.getQualifier());
                        return null;
                    }
                    CompletionGenerator.log("QN, SN Local Type " + CompletionGenerator.getNodeAsString((ASTNode)stp));
                    ASTNode typeDec = CompletionGenerator.findDeclaration2(stp.getName(), nearestNode);
                    if (typeDec == null) {
                        CompletionGenerator.log(stp.getName() + " couldn't be found locally..");
                        Class<?> tehClass5 = CompletionGenerator.findClassIfExists(ps, stp.getName().toString());
                        if (tehClass5 != null) {
                            return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(tehClass5), qn.getName().toString());
                        }
                        CompletionGenerator.log("QN resolve 3rd par, Can't resolve " + qn.getQualifier());
                        return null;
                    }
                    return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(ps, typeDec), qn.getName().toString());
                }
                ClassMember scopeParent = CompletionGenerator.resolveExpression3rdParty(ps, nearestNode, (ASTNode)qn.getQualifier(), noCompare);
                CompletionGenerator.log("QN, ScopeParent " + scopeParent);
                return CompletionGenerator.definedIn3rdPartyClass(ps, scopeParent, qn.getName().toString());
            }
            case 2: {
                ArrayAccess arac = (ArrayAccess)astNode;
                return CompletionGenerator.resolveExpression3rdParty(ps, nearestNode, (ASTNode)arac.getArray(), noCompare);
            }
            default: {
                CompletionGenerator.log("Unaccounted type " + CompletionGenerator.getNodeAsString(astNode));
            }
        }
        return null;
    }

    public static Class<?> getArrayClass(String elementClass, ClassLoader classLoader) {
        String name = elementClass.startsWith("[") ? "[" + elementClass : (elementClass.equals("boolean") ? "[Z" : (elementClass.equals("byte") ? "[B" : (elementClass.equals("char") ? "[C" : (elementClass.equals("double") ? "[D" : (elementClass.equals("float") ? "[F" : (elementClass.equals("int") ? "[I" : (elementClass.equals("long") ? "[J" : (elementClass.equals("short") ? "[S" : "[L" + elementClass + ";"))))))));
        return CompletionGenerator.loadClass(name, classLoader);
    }

    public static ASTNode getChildExpression(ASTNode expression) {
        if (expression instanceof SimpleName) {
            return expression;
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getName();
        }
        if (expression instanceof MethodInvocation) {
            return ((MethodInvocation)expression).getName();
        }
        if (expression instanceof ArrayAccess) {
            return ((ArrayAccess)expression).getArray();
        }
        CompletionGenerator.log(" getChildExpression returning NULL for " + CompletionGenerator.getNodeAsString(expression));
        return null;
    }

    public static ASTNode getParentExpression(ASTNode expression) {
        if (expression instanceof SimpleName) {
            return expression;
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getExpression();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getQualifier();
        }
        if (expression instanceof MethodInvocation) {
            return ((MethodInvocation)expression).getExpression();
        }
        if (expression instanceof ArrayAccess) {
            return ((ArrayAccess)expression).getArray();
        }
        CompletionGenerator.log("getParentExpression returning NULL for " + CompletionGenerator.getNodeAsString(expression));
        return null;
    }

    public static ArrayList<CompletionCandidate> getMembersForType(PreprocessedSketch ps, String typeName, String child, boolean noCompare, boolean staticOnly) {
        ArrayList<CompletionCandidate> candidates = new ArrayList<CompletionCandidate>();
        CompletionGenerator.log("In GMFT(), Looking for match " + child + " in class " + typeName + " noCompare " + noCompare + " staticOnly " + staticOnly);
        Class<?> probableClass = CompletionGenerator.findClassIfExists(ps, typeName);
        if (probableClass == null) {
            CompletionGenerator.log("In GMFT(), class not found.");
            return candidates;
        }
        return CompletionGenerator.getMembersForType(ps, new ClassMember(probableClass), child, noCompare, staticOnly);
    }

    public static ArrayList<CompletionCandidate> getMembersForType(PreprocessedSketch ps, ClassMember tehClass, String childToLookFor, boolean noCompare, boolean staticOnly) {
        Class<?> probableClass;
        String child = childToLookFor.toLowerCase();
        ArrayList<CompletionCandidate> candidates = new ArrayList<CompletionCandidate>();
        CompletionGenerator.log("getMemFoType-> Looking for match " + child + " inside " + tehClass + " noCompare " + noCompare + " staticOnly " + staticOnly);
        if (tehClass == null) {
            return candidates;
        }
        if (tehClass.getDeclaringNode() instanceof TypeDeclaration) {
            ArrayList<CompletionCandidate> superClassCandidates;
            FieldDeclaration[] fields;
            TypeDeclaration td = (TypeDeclaration)tehClass.getDeclaringNode();
            FieldDeclaration[] fieldDeclarationArray = fields = td.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration field = fieldDeclarationArray[n2];
                if (!staticOnly || CompletionGenerator.isStatic(field.modifiers())) {
                    List vdfs = field.fragments();
                    for (VariableDeclarationFragment vdf : vdfs) {
                        if (noCompare) {
                            candidates.add(new CompletionCandidate(vdf));
                            continue;
                        }
                        if (!vdf.getName().toString().toLowerCase().startsWith(child)) continue;
                        candidates.add(new CompletionCandidate(vdf));
                    }
                }
                ++n2;
            }
            MethodDeclaration[] methods = td.getMethods();
            fieldDeclarationArray = methods;
            n = methods.length;
            n2 = 0;
            while (n2 < n) {
                FieldDeclaration method = fieldDeclarationArray[n2];
                if (!staticOnly || CompletionGenerator.isStatic(method.modifiers())) {
                    if (noCompare) {
                        candidates.add(new CompletionCandidate((MethodDeclaration)method));
                    } else if (method.getName().toString().toLowerCase().startsWith(child)) {
                        candidates.add(new CompletionCandidate((MethodDeclaration)method));
                    }
                }
                ++n2;
            }
            if (td.getSuperclassType() != null) {
                CompletionGenerator.log(String.valueOf(CompletionGenerator.getNodeAsString((ASTNode)td.getSuperclassType())) + " <-Looking into superclass of " + tehClass);
                superClassCandidates = CompletionGenerator.getMembersForType(ps, new ClassMember(ps, (ASTNode)td.getSuperclassType()), childToLookFor, noCompare, staticOnly);
            } else {
                superClassCandidates = CompletionGenerator.getMembersForType(ps, new ClassMember(Object.class), childToLookFor, noCompare, staticOnly);
            }
            for (CompletionCandidate cc : superClassCandidates) {
                candidates.add(cc);
            }
            return candidates;
        }
        if (tehClass.getClass_() != null) {
            probableClass = tehClass.getClass_();
        } else {
            probableClass = CompletionGenerator.findClassIfExists(ps, tehClass.getTypeAsString());
            if (probableClass == null) {
                CompletionGenerator.log("Couldn't find class " + tehClass.getTypeAsString());
                return candidates;
            }
            CompletionGenerator.log("Loaded " + probableClass.toString());
        }
        AccessibleObject[] accessibleObjectArray = probableClass.getMethods();
        int n = accessibleObjectArray.length;
        int cc = 0;
        while (cc < n) {
            Method method = accessibleObjectArray[cc];
            if (java.lang.reflect.Modifier.isStatic(method.getModifiers()) || !staticOnly) {
                StringBuilder label = new StringBuilder(String.valueOf(method.getName()) + "(");
                int i = 0;
                while (i < method.getParameterTypes().length) {
                    label.append(method.getParameterTypes()[i].getSimpleName());
                    if (i < method.getParameterTypes().length - 1) {
                        label.append(",");
                    }
                    ++i;
                }
                label.append(")");
                if (noCompare) {
                    candidates.add(new CompletionCandidate(method));
                } else if (label.toString().toLowerCase().startsWith(child)) {
                    candidates.add(new CompletionCandidate(method));
                }
            }
            ++cc;
        }
        accessibleObjectArray = probableClass.getFields();
        n = accessibleObjectArray.length;
        cc = 0;
        while (cc < n) {
            AccessibleObject field = accessibleObjectArray[cc];
            if (java.lang.reflect.Modifier.isStatic(((Field)field).getModifiers()) || !staticOnly) {
                if (noCompare) {
                    candidates.add(new CompletionCandidate((Field)field));
                } else if (((Field)field).getName().toLowerCase().startsWith(child)) {
                    candidates.add(new CompletionCandidate((Field)field));
                }
            }
            ++cc;
        }
        if (probableClass.isArray() && !staticOnly) {
            String className = probableClass.getSimpleName();
            if (noCompare || "clone()".startsWith(child)) {
                String methodLabel = "<html>clone() : " + className + " - <font color=#777777>" + className + "</font></html>";
                candidates.add(new CompletionCandidate("clone()", methodLabel, "clone()", 2));
            }
            if ("length".startsWith(child)) {
                String fieldLabel = "<html>length : int - <font color=#777777>" + className + "</font></html>";
                candidates.add(new CompletionCandidate("length", fieldLabel, "length", 1));
            }
        }
        return candidates;
    }

    private static boolean isStatic(List<Modifier> modifiers) {
        for (Modifier m : modifiers) {
            if (!m.isStatic()) continue;
            return true;
        }
        return false;
    }

    protected static Class<?> findClassIfExists(PreprocessedSketch ps, String className) {
        Class<?> tehClass;
        if (className == null) {
            return null;
        }
        if (className.indexOf(46) >= 0) {
            String[] parts = className.split("\\.");
            String newClassName = parts[0];
            int i = 1;
            while (i < parts.length && ps.classPath.isPackage(newClassName)) {
                newClassName = String.valueOf(newClassName) + "/" + parts[i++];
            }
            while (i < parts.length) {
                newClassName = String.valueOf(newClassName) + "$" + parts[i++];
            }
            className = newClassName.replace('/', '.');
        }
        if ((tehClass = CompletionGenerator.loadClass(className, ps.classLoader)) != null) {
            return tehClass;
        }
        if (className.indexOf(46) >= 0) {
            return null;
        }
        CompletionGenerator.log("Looking in the classloader for " + className);
        List<ImportStatement> programImports = ps.programImports;
        List<ImportStatement> codeFolderImports = ps.codeFolderImports;
        List<ImportStatement> coreAndDefaultImports = ps.coreAndDefaultImports;
        ImportStatement javaLang = ImportStatement.wholePackage("java.lang");
        Stream<List> importListStream = Stream.of(Collections.singletonList(javaLang), coreAndDefaultImports, programImports, codeFolderImports);
        String finalClassName = className;
        return importListStream.map(list -> list.stream().map(is -> {
            if (is.getClassName().equals(finalClassName)) {
                return is.getFullClassName();
            }
            if (is.isStarredImport()) {
                return String.valueOf(is.getPackageName()) + "." + finalClassName;
            }
            return null;
        }).filter(name -> name != null).map(name -> CompletionGenerator.loadClass(name, preprocessedSketch.classLoader)).filter(cls -> cls != null).findAny()).filter(Optional::isPresent).map(Optional::get).findAny().orElse(null);
    }

    protected static Class<?> loadClass(String className, ClassLoader classLoader) {
        Class<?> tehClass = null;
        if (className != null) {
            try {
                tehClass = Class.forName(className, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return tehClass;
    }

    public static ClassMember definedIn3rdPartyClass(PreprocessedSketch ps, String className, String memberName) {
        Class<?> probableClass = CompletionGenerator.findClassIfExists(ps, className);
        if (probableClass == null) {
            CompletionGenerator.log("Couldn't load " + className);
            return null;
        }
        if (memberName.equals("THIS")) {
            return new ClassMember(probableClass);
        }
        return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(probableClass), memberName);
    }

    public static ClassMember definedIn3rdPartyClass(PreprocessedSketch ps, ClassMember tehClass, String memberName) {
        Class<?> probableClass;
        if (tehClass == null) {
            return null;
        }
        CompletionGenerator.log("definedIn3rdPartyClass-> Looking for " + memberName + " in " + tehClass);
        String memberNameL = memberName.toLowerCase();
        if (tehClass.getDeclaringNode() instanceof TypeDeclaration) {
            TypeDeclaration td = (TypeDeclaration)tehClass.getDeclaringNode();
            int i = 0;
            while (i < td.getFields().length) {
                List vdfs = td.getFields()[i].fragments();
                for (VariableDeclarationFragment vdf : vdfs) {
                    if (!vdf.getName().toString().toLowerCase().startsWith(memberNameL)) continue;
                    return new ClassMember(ps, (ASTNode)vdf);
                }
                ++i;
            }
            i = 0;
            while (i < td.getMethods().length) {
                if (td.getMethods()[i].getName().toString().toLowerCase().startsWith(memberNameL)) {
                    return new ClassMember(ps, (ASTNode)td.getMethods()[i]);
                }
                ++i;
            }
            if (td.getSuperclassType() != null) {
                CompletionGenerator.log(String.valueOf(CompletionGenerator.getNodeAsString((ASTNode)td.getSuperclassType())) + " <-Looking into superclass of " + tehClass);
                return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(ps, (ASTNode)td.getSuperclassType()), memberName);
            }
            return CompletionGenerator.definedIn3rdPartyClass(ps, new ClassMember(Object.class), memberName);
        }
        if (tehClass.getClass_() != null) {
            probableClass = tehClass.getClass_();
        } else {
            probableClass = CompletionGenerator.findClassIfExists(ps, tehClass.getTypeAsString());
            CompletionGenerator.log("Loaded " + probableClass.toString());
        }
        AccessibleObject[] accessibleObjectArray = probableClass.getMethods();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = accessibleObjectArray[n2];
            if (method.getName().equalsIgnoreCase(memberName)) {
                return new ClassMember(method);
            }
            ++n2;
        }
        accessibleObjectArray = probableClass.getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject field = accessibleObjectArray[n2];
            if (((Field)field).getName().equalsIgnoreCase(memberName)) {
                return new ClassMember((Field)field);
            }
            ++n2;
        }
        return null;
    }

    protected static ASTNode findClosestParentNode(int lineNumber, ASTNode node) {
        for (StructuralPropertyDescriptor prop : node.structuralPropertiesForType()) {
            if (prop.isChildProperty() || prop.isSimpleProperty()) {
                if (node.getStructuralProperty(prop) == null || !(node.getStructuralProperty(prop) instanceof ASTNode)) continue;
                ASTNode cnode = (ASTNode)node.getStructuralProperty(prop);
                int cLineNum = ((CompilationUnit)cnode.getRoot()).getLineNumber(cnode.getStartPosition() + cnode.getLength());
                if (CompletionGenerator.getLineNumber(cnode) > lineNumber || lineNumber > cLineNum) continue;
                return CompletionGenerator.findClosestParentNode(lineNumber, cnode);
            }
            if (!prop.isChildListProperty()) continue;
            List nodelist = (List)node.getStructuralProperty(prop);
            for (ASTNode cnode : nodelist) {
                int cLineNum = ((CompilationUnit)cnode.getRoot()).getLineNumber(cnode.getStartPosition() + cnode.getLength());
                if (CompletionGenerator.getLineNumber(cnode) > lineNumber || lineNumber > cLineNum) continue;
                return CompletionGenerator.findClosestParentNode(lineNumber, cnode);
            }
        }
        return node;
    }

    protected static ASTNode findClosestNode(int lineNumber, ASTNode node) {
        List nodes;
        CompletionGenerator.log("findClosestNode to line " + lineNumber);
        ASTNode parent = CompletionGenerator.findClosestParentNode(lineNumber, node);
        CompletionGenerator.log("findClosestParentNode returned " + CompletionGenerator.getNodeAsString(parent));
        if (parent == null) {
            return null;
        }
        if (CompletionGenerator.getLineNumber(parent) == lineNumber) {
            CompletionGenerator.log(parent + "|PNode " + CompletionGenerator.getLineNumber(parent) + ", lfor " + lineNumber);
            return parent;
        }
        if (parent instanceof TypeDeclaration) {
            nodes = ((TypeDeclaration)parent).bodyDeclarations();
        } else if (parent instanceof Block) {
            nodes = ((Block)parent).statements();
        } else {
            CompletionGenerator.log("findClosestNode() found " + CompletionGenerator.getNodeAsString(parent));
            return null;
        }
        if (nodes.size() > 0) {
            ASTNode retNode = parent;
            for (ASTNode cNode : nodes) {
                CompletionGenerator.log(cNode + "|cNode " + CompletionGenerator.getLineNumber(cNode) + ", lfor " + lineNumber);
                if (CompletionGenerator.getLineNumber(cNode) > lineNumber) continue;
                retNode = cNode;
            }
            return retNode;
        }
        return parent;
    }

    public static int getLineNumber(ASTNode node) {
        return ((CompilationUnit)node.getRoot()).getLineNumber(node.getStartPosition());
    }

    protected static ASTNode findDeclaration(Name findMe) {
        ASTNode parent = findMe.getParent();
        ArrayList<Integer> constrains = new ArrayList<Integer>();
        if (parent.getNodeType() == 32) {
            Expression exp = (Expression)parent.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY);
            if (((MethodInvocation)parent).getName().toString().equals(findMe.toString())) {
                constrains.add(31);
                if (exp != null) {
                    constrains.add(55);
                    if (exp instanceof MethodInvocation) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration((Name)((MethodInvocation)exp).getName()));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration(stp.getName());
                        return CompletionGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                    if (exp instanceof FieldAccess) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration((Name)((FieldAccess)exp).getName()));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration(stp.getName());
                        return CompletionGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                    if (exp instanceof SimpleName) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration((Name)((SimpleName)exp)));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration(stp.getName());
                        constrains.add(31);
                        return CompletionGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                }
            } else {
                parent = parent.getParent();
            }
        } else if (parent.getNodeType() == 22) {
            FieldAccess fa = (FieldAccess)parent;
            Expression exp = fa.getExpression();
            if (fa.getName().toString().equals(findMe.toString())) {
                constrains.add(23);
                if (exp != null) {
                    constrains.add(55);
                    if (exp instanceof MethodInvocation) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration((Name)((MethodInvocation)exp).getName()));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration(stp.getName());
                        return CompletionGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                    if (exp instanceof FieldAccess) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration((Name)((FieldAccess)exp).getName()));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration(stp.getName());
                        constrains.add(55);
                        return CompletionGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                    if (exp instanceof SimpleName) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration((Name)((SimpleName)exp)));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration(stp.getName());
                        constrains.add(31);
                        return CompletionGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                }
            } else {
                parent = parent.getParent();
            }
        } else if (parent.getNodeType() == 40) {
            QualifiedName qn = (QualifiedName)parent;
            if (!findMe.toString().equals(qn.getQualifier().toString())) {
                SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration(qn.getQualifier()));
                if (stp == null) {
                    return null;
                }
                ASTNode declaringClass = CompletionGenerator.findDeclaration(stp.getName());
                constrains.clear();
                constrains.add(55);
                constrains.add(23);
                return CompletionGenerator.definedIn(declaringClass, qn.getName().toString(), constrains);
            }
            if (findMe instanceof QualifiedName) {
                QualifiedName qnn = (QualifiedName)findMe;
                SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration(qnn.getQualifier()));
                if (stp == null) {
                    return null;
                }
                ASTNode declaringClass = CompletionGenerator.findDeclaration(stp.getName());
                constrains.clear();
                constrains.add(55);
                constrains.add(23);
                return CompletionGenerator.definedIn(declaringClass, qnn.getName().toString(), constrains);
            }
        } else if (parent.getNodeType() == 43) {
            constrains.add(55);
            if (parent.getParent().getNodeType() == 14) {
                constrains.add(14);
            }
        } else if (parent.getNodeType() == 55) {
            TypeDeclaration td = (TypeDeclaration)parent;
            if (findMe.equals((Object)td.getName())) {
                return parent;
            }
        } else {
            boolean cfr_ignored_0 = parent instanceof Expression;
        }
        while (parent != null) {
            for (Object oprop : parent.structuralPropertiesForType()) {
                ASTNode ret;
                StructuralPropertyDescriptor prop = (StructuralPropertyDescriptor)oprop;
                if (prop.isChildProperty() || prop.isSimpleProperty()) {
                    if (!(parent.getStructuralProperty(prop) instanceof ASTNode) || (ret = CompletionGenerator.definedIn((ASTNode)parent.getStructuralProperty(prop), findMe.toString(), constrains)) == null) continue;
                    return ret;
                }
                if (!prop.isChildListProperty()) continue;
                List nodelist = (List)parent.getStructuralProperty(prop);
                for (ASTNode retNode : nodelist) {
                    ret = CompletionGenerator.definedIn(retNode, findMe.toString(), constrains);
                    if (ret == null) continue;
                    return ret;
                }
            }
            parent = parent.getParent();
        }
        return null;
    }

    protected static ASTNode findDeclaration2(Name findMe, ASTNode alternateParent) {
        ASTNode parent = findMe.getParent();
        ArrayList<Integer> constrains = new ArrayList<Integer>();
        if (parent.getNodeType() == 32) {
            Expression exp = (Expression)parent.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY);
            if (((MethodInvocation)parent).getName().toString().equals(findMe.toString())) {
                constrains.add(31);
                if (exp != null) {
                    constrains.add(55);
                    if (exp instanceof MethodInvocation) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2((Name)((MethodInvocation)exp).getName(), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration2(stp.getName(), alternateParent);
                        return CompletionGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                    if (exp instanceof FieldAccess) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2((Name)((FieldAccess)exp).getName(), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration2(stp.getName(), alternateParent);
                        return CompletionGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                    if (exp instanceof SimpleName) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2((Name)((SimpleName)exp), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration2(stp.getName(), alternateParent);
                        constrains.add(31);
                        return CompletionGenerator.definedIn(declaringClass, ((MethodInvocation)parent).getName().toString(), constrains);
                    }
                }
            } else {
                parent = parent.getParent();
                alternateParent = alternateParent.getParent();
            }
        } else if (parent.getNodeType() == 22) {
            FieldAccess fa = (FieldAccess)parent;
            Expression exp = fa.getExpression();
            if (fa.getName().toString().equals(findMe.toString())) {
                constrains.add(23);
                if (exp != null) {
                    constrains.add(55);
                    if (exp instanceof MethodInvocation) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2((Name)((MethodInvocation)exp).getName(), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration2(stp.getName(), alternateParent);
                        return CompletionGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                    if (exp instanceof FieldAccess) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2((Name)((FieldAccess)exp).getName(), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration2(stp.getName(), alternateParent);
                        constrains.add(55);
                        return CompletionGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                    if (exp instanceof SimpleName) {
                        SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2((Name)((SimpleName)exp), alternateParent));
                        if (stp == null) {
                            return null;
                        }
                        ASTNode declaringClass = CompletionGenerator.findDeclaration2(stp.getName(), alternateParent);
                        constrains.add(31);
                        return CompletionGenerator.definedIn(declaringClass, fa.getName().toString(), constrains);
                    }
                }
            } else {
                parent = parent.getParent();
                alternateParent = alternateParent.getParent();
            }
        } else if (parent.getNodeType() == 40) {
            QualifiedName qn = (QualifiedName)parent;
            if (!findMe.toString().equals(qn.getQualifier().toString())) {
                SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2(qn.getQualifier(), alternateParent));
                if (stp == null) {
                    return null;
                }
                ASTNode declaringClass = CompletionGenerator.findDeclaration2(stp.getName(), alternateParent);
                constrains.clear();
                constrains.add(55);
                constrains.add(23);
                return CompletionGenerator.definedIn(declaringClass, qn.getName().toString(), constrains);
            }
            if (findMe instanceof QualifiedName) {
                QualifiedName qnn = (QualifiedName)findMe;
                SimpleType stp = CompletionGenerator.extracTypeInfo(CompletionGenerator.findDeclaration2(qnn.getQualifier(), alternateParent));
                if (stp == null) {
                    return null;
                }
                ASTNode declaringClass = CompletionGenerator.findDeclaration2(stp.getName(), alternateParent);
                constrains.clear();
                constrains.add(55);
                constrains.add(23);
                return CompletionGenerator.definedIn(declaringClass, qnn.getName().toString(), constrains);
            }
        } else if (parent.getNodeType() == 43) {
            constrains.add(55);
            if (parent.getParent().getNodeType() == 14) {
                constrains.add(14);
            }
        } else {
            boolean cfr_ignored_0 = parent instanceof Expression;
        }
        while (alternateParent != null) {
            for (Object oprop : alternateParent.structuralPropertiesForType()) {
                ASTNode ret;
                StructuralPropertyDescriptor prop = (StructuralPropertyDescriptor)oprop;
                if (prop.isChildProperty() || prop.isSimpleProperty()) {
                    if (!(alternateParent.getStructuralProperty(prop) instanceof ASTNode) || (ret = CompletionGenerator.definedIn((ASTNode)alternateParent.getStructuralProperty(prop), findMe.toString(), constrains)) == null) continue;
                    return ret;
                }
                if (!prop.isChildListProperty()) continue;
                List nodelist = (List)alternateParent.getStructuralProperty(prop);
                for (ASTNode retNode : nodelist) {
                    ret = CompletionGenerator.definedIn(retNode, findMe.toString(), constrains);
                    if (ret == null) continue;
                    return ret;
                }
            }
            alternateParent = alternateParent.getParent();
        }
        return null;
    }

    protected static boolean ignorableSuggestionImport(PreprocessedSketch ps, String impName) {
        String impNameLc = impName.toLowerCase();
        List<ImportStatement> programImports = ps.programImports;
        List<ImportStatement> codeFolderImports = ps.codeFolderImports;
        boolean isImported = Stream.concat(programImports.stream(), codeFolderImports.stream()).anyMatch(impS -> {
            String packageNameLc = impS.getPackageName().toLowerCase();
            return impNameLc.startsWith(packageNameLc);
        });
        if (isImported) {
            return false;
        }
        if (impName.startsWith("processing")) {
            if (JavaMode.suggestionsMap.containsKey("include") && JavaMode.suggestionsMap.get("include").contains(impName)) {
                return false;
            }
            if (JavaMode.suggestionsMap.containsKey("exclude") && JavaMode.suggestionsMap.get("exclude").contains(impName)) {
                return true;
            }
        } else if (impName.startsWith("java") && JavaMode.suggestionsMap.containsKey("include") && JavaMode.suggestionsMap.get("include").contains(impName)) {
            return false;
        }
        return true;
    }

    public static SimpleType extracTypeInfo(ASTNode node) {
        if (node == null) {
            return null;
        }
        Type t = CompletionGenerator.extracTypeInfo2(node);
        if (t instanceof PrimitiveType) {
            return null;
        }
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            CompletionGenerator.log("ele type " + at.getElementType() + ", " + at.getElementType().getClass().getName());
            if (at.getElementType() instanceof PrimitiveType) {
                return null;
            }
            if (at.getElementType() instanceof SimpleType) {
                return (SimpleType)at.getElementType();
            }
            return null;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pmt = (ParameterizedType)t;
            CompletionGenerator.log(pmt.getType() + ", " + pmt.getType().getClass());
            if (pmt.getType() instanceof SimpleType) {
                return (SimpleType)pmt.getType();
            }
            return null;
        }
        return (SimpleType)t;
    }

    public static Type extracTypeInfo2(ASTNode node) {
        Messages.log((String)"* extracTypeInfo2");
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 31: {
                return ((MethodDeclaration)node).getReturnType2();
            }
            case 23: {
                return ((FieldDeclaration)node).getType();
            }
            case 58: {
                return ((VariableDeclarationExpression)node).getType();
            }
            case 60: {
                return ((VariableDeclarationStatement)node).getType();
            }
            case 44: {
                return ((SingleVariableDeclaration)node).getType();
            }
            case 59: {
                return CompletionGenerator.extracTypeInfo2(node.getParent());
            }
        }
        CompletionGenerator.log("Unknown type info request " + CompletionGenerator.getNodeAsString(node));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ASTNode definedIn(ASTNode node, String name, ArrayList<Integer> constrains) {
        if (node == null) {
            return null;
        }
        if (constrains != null && !constrains.contains(node.getNodeType()) && constrains.size() > 0) {
            return null;
        }
        List vdfList = null;
        switch (node.getNodeType()) {
            case 55: {
                MethodDeclaration md;
                int n;
                int n2;
                MethodDeclaration[] methodDeclarationArray;
                MethodDeclaration[] methods;
                TypeDeclaration td = (TypeDeclaration)node;
                if (td.getName().toString().equals(name)) {
                    if (!constrains.contains(14)) return node;
                    methodDeclarationArray = methods = td.getMethods();
                    n2 = methods.length;
                    n = 0;
                    while (n < n2) {
                        md = methodDeclarationArray[n];
                        if (md.getName().toString().equalsIgnoreCase(name)) {
                            CompletionGenerator.log("Found a constructor.");
                            return md;
                        }
                        ++n;
                    }
                } else if (constrains.contains(23)) {
                    FieldDeclaration[] fields = td.getFields();
                    methodDeclarationArray = fields;
                    n2 = fields.length;
                    n = 0;
                    while (n < n2) {
                        MethodDeclaration fd = methodDeclarationArray[n];
                        List fragments = fd.fragments();
                        for (VariableDeclarationFragment vdf : fragments) {
                            if (!vdf.getName().toString().equalsIgnoreCase(name)) continue;
                            return fd;
                        }
                        ++n;
                    }
                } else {
                    if (!constrains.contains(31)) break;
                    methodDeclarationArray = methods = td.getMethods();
                    n2 = methods.length;
                    n = 0;
                    while (n < n2) {
                        md = methodDeclarationArray[n];
                        if (md.getName().toString().equalsIgnoreCase(name)) {
                            return md;
                        }
                        ++n;
                    }
                }
                break;
            }
            case 31: {
                if (!((MethodDeclaration)node).getName().toString().equalsIgnoreCase(name)) break;
                return node;
            }
            case 44: {
                if (!((SingleVariableDeclaration)node).getName().toString().equalsIgnoreCase(name)) break;
                return node;
            }
            case 23: {
                vdfList = ((FieldDeclaration)node).fragments();
                break;
            }
            case 58: {
                vdfList = ((VariableDeclarationExpression)node).fragments();
                break;
            }
            case 60: {
                vdfList = ((VariableDeclarationStatement)node).fragments();
            }
        }
        if (vdfList == null) return null;
        for (VariableDeclarationFragment vdf : vdfList) {
            if (!vdf.getName().toString().equalsIgnoreCase(name)) continue;
            return node;
        }
        return null;
    }

    protected static String getNodeAsString(ASTNode node) {
        if (node == null) {
            return "NULL";
        }
        String className = node.getClass().getName();
        int index = className.lastIndexOf(".");
        if (index > 0) {
            className = className.substring(index + 1);
        }
        String value = className;
        if (node instanceof TypeDeclaration) {
            value = String.valueOf(((TypeDeclaration)node).getName().toString()) + " | " + className;
        } else if (node instanceof MethodDeclaration) {
            value = String.valueOf(((MethodDeclaration)node).getName().toString()) + " | " + className;
        } else if (node instanceof MethodInvocation) {
            value = String.valueOf(((MethodInvocation)node).getName().toString()) + " | " + className;
        } else if (node instanceof FieldDeclaration) {
            value = String.valueOf(node.toString()) + " FldDecl | ";
        } else if (node instanceof SingleVariableDeclaration) {
            value = ((SingleVariableDeclaration)node).getName() + " - " + ((SingleVariableDeclaration)node).getType() + " | SVD ";
        } else if (node instanceof ExpressionStatement) {
            value = String.valueOf(node.toString()) + className;
        } else if (node instanceof SimpleName) {
            value = String.valueOf(((SimpleName)node).getFullyQualifiedName()) + " | " + className;
        } else if (node instanceof QualifiedName) {
            value = String.valueOf(node.toString()) + " | " + className;
        } else if (node instanceof FieldAccess) {
            value = String.valueOf(node.toString()) + " | ";
        } else if (className.startsWith("Variable")) {
            value = String.valueOf(node.toString()) + " | " + className;
        } else if (className.endsWith("Type")) {
            value = String.valueOf(node.toString()) + " | " + className;
        }
        value = String.valueOf(value) + " [" + node.getStartPosition() + "," + (node.getStartPosition() + node.getLength()) + "]";
        value = String.valueOf(value) + " Line: " + ((CompilationUnit)node.getRoot()).getLineNumber(node.getStartPosition());
        return value;
    }

    private static void log(Object object) {
        Messages.log((String)(object == null ? "null" : object.toString()));
    }

    protected static List<CompletionCandidate> trimCandidates(String newWord, List<CompletionCandidate> candidates) {
        ArrayList<CompletionCandidate> newCandidate = new ArrayList<CompletionCandidate>();
        newWord = newWord.toLowerCase();
        for (CompletionCandidate comp : candidates) {
            if (!comp.startsWith(newWord)) continue;
            newCandidate.add(comp);
        }
        return newCandidate;
    }

    public List<CompletionCandidate> preparePredictions(PreprocessedSketch ps, String pdePhrase, int lineNumber) {
        ASTNode nearestNode;
        boolean incremental;
        Messages.log((String)"* preparePredictions");
        ASTNode astRootNode = (ASTNode)ps.compilationUnit.types().get(0);
        TextTransform transform = new TextTransform(pdePhrase);
        transform.addAll(SourceUtils.replaceTypeConstructors(pdePhrase));
        transform.addAll(SourceUtils.replaceHexLiterals(pdePhrase));
        transform.addAll(SourceUtils.replaceColorRegex(pdePhrase));
        transform.addAll(SourceUtils.fixFloatsRegex(pdePhrase));
        String phrase = transform.apply();
        boolean noCompare = phrase.endsWith(".");
        if (noCompare) {
            phrase = phrase.substring(0, phrase.length() - 1);
        }
        boolean bl = incremental = !noCompare && phrase.length() > this.lastPredictedPhrase.length() && phrase.startsWith(this.lastPredictedPhrase);
        if (incremental) {
            CompletionGenerator.log(String.valueOf(pdePhrase) + " starts with " + this.lastPredictedPhrase);
            CompletionGenerator.log("Don't recalc");
            if (phrase.contains(".")) {
                int x = phrase.lastIndexOf(46);
                this.candidates = CompletionGenerator.trimCandidates(phrase.substring(x + 1), this.candidates);
            } else {
                this.candidates = CompletionGenerator.trimCandidates(phrase, this.candidates);
            }
            this.lastPredictedPhrase = phrase;
            return this.candidates;
        }
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setKind(1);
        parser.setSource(phrase.toCharArray());
        ASTNode testnode = parser.createAST(null);
        Messages.loge((String)("Typed: " + phrase + "|" + " temp Node type: " + testnode.getClass().getSimpleName()));
        if (testnode instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)testnode;
            CompletionGenerator.log(mi.getName() + "," + mi.getExpression() + "," + mi.typeArguments().size());
        }
        if ((nearestNode = CompletionGenerator.findClosestNode(lineNumber, astRootNode)) == null) {
            nearestNode = astRootNode;
        }
        Messages.loge((String)(String.valueOf(lineNumber) + " Nearest ASTNode to PRED " + CompletionGenerator.getNodeAsString(nearestNode)));
        this.candidates = new ArrayList<CompletionCandidate>();
        this.lastPredictedPhrase = phrase;
        if (testnode instanceof SimpleName && !noCompare) {
            Messages.loge((String)("One word expression " + CompletionGenerator.getNodeAsString(testnode)));
            while (nearestNode != null) {
                TypeDeclaration td;
                if (nearestNode instanceof TypeDeclaration && (td = (TypeDeclaration)nearestNode).getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY) != null) {
                    SimpleType st = (SimpleType)td.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY);
                    CompletionGenerator.log("Superclass " + st.getName());
                    ArrayList<CompletionCandidate> tempCandidates = CompletionGenerator.getMembersForType(ps, st.getName().toString(), phrase, false, false);
                    Iterator iterator = tempCandidates.iterator();
                    while (iterator.hasNext()) {
                        CompletionCandidate can = (CompletionCandidate)iterator.next();
                        this.candidates.add(can);
                    }
                }
                List sprops = nearestNode.structuralPropertiesForType();
                for (StructuralPropertyDescriptor sprop : sprops) {
                    if (!sprop.isChildListProperty()) {
                        ASTNode cnode;
                        CompletionCandidate[] types;
                        if (!(nearestNode.getStructuralProperty(sprop) instanceof ASTNode) || (types = CompletionGenerator.checkForTypes(cnode = (ASTNode)nearestNode.getStructuralProperty(sprop))) == null) continue;
                        CompletionCandidate[] completionCandidateArray = types;
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CompletionCandidate type = completionCandidateArray[n2];
                            if (type.getElementName().toLowerCase().startsWith(phrase.toLowerCase())) {
                                this.candidates.add(type);
                            }
                            ++n2;
                        }
                        continue;
                    }
                    List nodelist = (List)nearestNode.getStructuralProperty(sprop);
                    for (ASTNode clnode : nodelist) {
                        CompletionCandidate[] types = CompletionGenerator.checkForTypes(clnode);
                        if (types == null) continue;
                        CompletionCandidate[] completionCandidateArray = types;
                        int n = types.length;
                        int n3 = 0;
                        while (n3 < n) {
                            CompletionCandidate type = completionCandidateArray[n3];
                            if (type.getElementName().toLowerCase().startsWith(phrase.toLowerCase())) {
                                this.candidates.add(type);
                            }
                            ++n3;
                        }
                    }
                }
                nearestNode = nearestNode.getParent();
            }
            CompletionGenerator.log("Empty can. " + phrase);
            ClassPath classPath = ps.classPath;
            if (classPath != null) {
                String[] resources;
                RegExpResourceFilter regExpResourceFilter = new RegExpResourceFilter(Pattern.compile(".*"), Pattern.compile(String.valueOf(phrase) + "[a-zA-Z_0-9]*.class", 2));
                String[] stringArray = resources = classPath.findResources("", (ResourceFilter)regExpResourceFilter);
                int clnode = resources.length;
                int nodelist = 0;
                while (nodelist < clnode) {
                    String matchedClass2 = stringArray[nodelist];
                    matchedClass2 = matchedClass2.replace('/', '.');
                    String matchedClass = matchedClass2.substring(0, matchedClass2.length() - 6);
                    int d = matchedClass.lastIndexOf(46);
                    if (!CompletionGenerator.ignorableSuggestionImport(ps, matchedClass)) {
                        matchedClass = matchedClass.substring(d + 1);
                        String html = "<html>" + matchedClass + " : <font color=#777777>" + matchedClass2.substring(0, d) + "</font></html>";
                        this.candidates.add(new CompletionCandidate(matchedClass, html, matchedClass, 0));
                    }
                    ++nodelist;
                }
            }
        } else {
            ClassMember expr;
            Messages.loge((String)("Complex expression " + CompletionGenerator.getNodeAsString(testnode)));
            CompletionGenerator.log("candidates empty");
            ASTNode childExpr = CompletionGenerator.getChildExpression(testnode);
            CompletionGenerator.log("Parent expression : " + CompletionGenerator.getParentExpression(testnode));
            CompletionGenerator.log("Child expression : " + childExpr);
            if (!noCompare) {
                CompletionGenerator.log("Original testnode " + CompletionGenerator.getNodeAsString(testnode));
                testnode = CompletionGenerator.getParentExpression(testnode);
                CompletionGenerator.log("Corrected testnode " + CompletionGenerator.getNodeAsString(testnode));
            }
            if ((expr = CompletionGenerator.resolveExpression3rdParty(ps, nearestNode, testnode, noCompare)) == null) {
                CompletionGenerator.log("Expr is null");
            } else {
                boolean isArray = expr.thisclass != null && expr.thisclass.isArray();
                boolean isSimpleType = expr.astNode != null && expr.astNode.getNodeType() == 43;
                boolean isMethod = expr.method != null;
                boolean staticOnly = !isMethod && !isArray && !isSimpleType;
                CompletionGenerator.log("Expr is " + expr.toString());
                String lookFor = noCompare || childExpr == null ? "" : childExpr.toString();
                this.candidates = CompletionGenerator.getMembersForType(ps, expr, lookFor, noCompare, staticOnly);
            }
        }
        return this.candidates;
    }

    protected static DefaultListModel<CompletionCandidate> filterPredictions(List<CompletionCandidate> candidates) {
        Messages.log((String)"* filterPredictions");
        DefaultListModel<CompletionCandidate> defListModel = new DefaultListModel<CompletionCandidate>();
        if (candidates.isEmpty()) {
            return defListModel;
        }
        if (candidates.get(0).getElementName().equals(candidates.get(candidates.size() - 1).getElementName())) {
            CompletionGenerator.log("All CC are methods only: " + candidates.get(0).getElementName());
            int i = 0;
            while (i < candidates.size()) {
                CompletionCandidate cc = candidates.get(i).withRegeneratedCompString();
                candidates.set(i, cc);
                defListModel.addElement(cc);
                ++i;
            }
        } else {
            boolean ignoredSome = false;
            int i = 0;
            while (i < candidates.size()) {
                if (i > 0 && candidates.get(i).getElementName().equals(candidates.get(i - 1).getElementName()) && (candidates.get(i).getType() == 4 || candidates.get(i).getType() == 2)) {
                    CompletionCandidate cc = candidates.get(i - 1);
                    String label = cc.getLabel();
                    int x = label.lastIndexOf(41);
                    String newLabel = candidates.get(i).getType() == 2 ? String.valueOf(cc.getLabel().contains("<html>") ? "<html>" : "") + cc.getElementName() + "(...)" + label.substring(x + 1) : String.valueOf(cc.getElementName()) + "(...)" + label.substring(x + 1);
                    String newCompString = String.valueOf(cc.getElementName()) + "(";
                    candidates.set(i - 1, cc.withLabelAndCompString(newLabel, newCompString));
                    ignoredSome = true;
                } else {
                    defListModel.addElement(candidates.get(i));
                }
                ++i;
            }
            if (ignoredSome) {
                CompletionGenerator.log("Some suggestions hidden");
            }
        }
        return defListModel;
    }

    public static class ClassMember {
        private Field field;
        private Method method;
        private Constructor<?> cons;
        private Class<?> thisclass;
        private String stringVal;
        private String classType;
        private ASTNode astNode;
        private ASTNode declaringNode;

        public ClassMember(Class<?> m) {
            this.thisclass = m;
            this.stringVal = "Predefined Class " + m.getName();
            this.classType = m.getName();
        }

        public ClassMember(Method m) {
            this.method = m;
            this.stringVal = "Method " + m.getReturnType().getName() + " | " + m.getName() + " defined in " + m.getDeclaringClass().getName();
            this.classType = m.getReturnType().getName();
        }

        public ClassMember(Field m) {
            this.field = m;
            this.stringVal = "Field " + m.getType().getName() + " | " + m.getName() + " defined in " + m.getDeclaringClass().getName();
            this.classType = m.getType().getName();
        }

        public ClassMember(Constructor<?> m) {
            this.cons = m;
            this.stringVal = "Cons  " + m.getName() + " defined in " + m.getDeclaringClass().getName();
        }

        public ClassMember(PreprocessedSketch ps, ASTNode node) {
            SimpleType stp;
            this.astNode = node;
            this.stringVal = CompletionGenerator.getNodeAsString(node);
            if (node instanceof TypeDeclaration) {
                this.declaringNode = node;
            }
            if (node instanceof SimpleType) {
                this.classType = ((SimpleType)node).getName().toString();
            }
            SimpleType simpleType = stp = node instanceof SimpleType ? (SimpleType)node : CompletionGenerator.extracTypeInfo(node);
            if (stp != null) {
                ASTNode decl = CompletionGenerator.findDeclaration(stp.getName());
                if (decl == null) {
                    this.classType = stp.getName().toString();
                    this.thisclass = CompletionGenerator.findClassIfExists(ps, this.classType);
                } else {
                    this.declaringNode = decl;
                }
            }
        }

        public Class<?> getClass_() {
            return this.thisclass;
        }

        public ASTNode getDeclaringNode() {
            return this.declaringNode;
        }

        public Field getField() {
            return this.field;
        }

        public Method getMethod() {
            return this.method;
        }

        public Constructor<?> getCons() {
            return this.cons;
        }

        public ASTNode getASTNode() {
            return this.astNode;
        }

        public String toString() {
            return this.stringVal;
        }

        public String getTypeAsString() {
            return this.classType;
        }
    }
}

