/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6wO902mFU3XMJYceJdotTlPGzS6YgH3yYpFbZw2FTx01CWIrH4crEd9zz1eWg82keQF7tBxJutuZ_KLqfNlVD2FQiZN5UKPHB0Xwl4sk6RQvjmV2d2KlWZjJWfuF5n0bqTtfBCiTANQVa85C9s9S14-RrrZgP2tv1mcd-zyr5RAlgiAGBgiwVxf2SL807Z2x_5ETowPoBbUrwKqeGAVkNC5DLOUvTgAlJWmIOEBrR-TRrMHMJF0GASwsS0HEepD3CnUjCx8Xi_OVzGzeip73Kf5RGd7KBedEFo-TsJRGVOu44nAxADWmvb3AOLgWUyYDcCGcWeRwB4PZipLRdkXXS4CB-_AFHbBZaShCuMYJsDq31KxVnW58hzJK96RxDmFAH4QB6KjITM7SX3ldOJ4LwGSDDuB2pe9Ma1g2l0bTyEan-rEJMrqD1Lxo3CczsIxKATi6jCsClirrIAByxpRDjF4UKowHwcpzUQxtSGx8tL8hp_XZj3784TpxoOiALfvQ03y2lLGBbUJdf-mR2oaGzzRjYJmwLwxSHn4Ocp9CBFOgjbYB_5YNjx4LMLOO2_helYuq8GCjTELoD_HjMfaqTBvGafPMBXzwT5gz369DnaplFFqP7NCv_xzIlCDCYXleIedPfci4HUGSMaqN6nE1QQ77Gsu2iWBbxheLk_SF-NK-8FEMPGGYjpcZVL_nGjrr4M8wrdGrnGnW_fJI5ed3WWW5xOBUHfL-fAqKknwkdkaJO-w-w9F7NJDZ40SwHMCHldeHtDqme-hDaGtjUymXU8Wlowkl-_0Tgm3MuTuR_aZDds0Wd-c54P568nhRrlsfSBU24bdK9HShybt5prmyT2TudScYGyoysXo7B0oL1qbQwfyCFomPVFjCDkolIf4tu7bfc8PmP7mCBXzDUjJa4edDT9PZPYS0bofUiTzymdMXwfQQaoriYCd3Lnz29lWnle2bCXMU1jQwUr6SGOmIvyIyLrOjAsjLyR60YbaXw4iBfMggADBdD3BYh47FGUjW-yt25kYbNdl3c51u6wAx6XkmJH7JLKp_Q0AUY2gA9NefayG0lkR3hzL3Onry_6Pq7n47oEwI4485QewUE2tDjsDO1-ij-l_pPJbv3_xytslQmQaLztnM0NI2aF_hA1W7JLtjCmflNJwSE1om0gasJcBbfQMdGG91v9QTFdMTPgHtOaIvBLdqZkD3PRvI8Gv8OyFoYtwAeiQKaxwSh3YL3_lE6-4aXyZhdwBAcXHNfP6Q6C4cTdOKvsdiLhlXheihyA0UN12e-_NZqyqiTuqrNq1g61uqvESZSkZGmxMWfgQ5iIom8iRwtYVzKAR7RyQcW5qbW3dJ0000";

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(new UTranslate(0.0, header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(new UTranslate(x, 0.0)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(PSystemVersion.getPlantumlImage());
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        TranscoderImpl t = new TranscoderImpl(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        String s = t.decode(DONORS).replace('*', '.');
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

