/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;

public class CommandArchimateMultilines
extends CommandMultilines2<AbstractEntityDiagram> {
    public CommandArchimateMultilines() {
        super(CommandArchimateMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^(.*)\\]$";
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandArchimateMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf("archimate"), RegexLeaf.spaceOneOrMore(), CommandArchimateMultilines.color().getRegex(), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\["), new RegexLeaf("DESC", "(.*)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines) {
        lines = lines.trim(false);
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst499().getTrimmed().getString());
        String codeRaw = line0.getLazzy("CODE", 0);
        Code code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeRaw));
        String icon = line0.getLazzy("STEREOTYPE", 0);
        IEntity entity = diagram.getOrCreateLeaf(code, LeafType.DESCRIPTION, USymbol.RECTANGLE);
        lines = lines.subExtract(1, 1);
        Display display = lines.toDisplay();
        entity.setDisplay(display);
        entity.setUSymbol(USymbol.RECTANGLE);
        if (icon != null) {
            entity.setStereotype(new Stereotype("<<$archimate/" + icon + ">>", diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        Colors colors = CommandArchimateMultilines.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        entity.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

