/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.NullOutputStream;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;

public class SourceStringReader {
    private final List<BlockUml> blocks;

    public SourceStringReader(String source) {
        this(Defines.createEmpty(), source, Collections.emptyList());
    }

    public SourceStringReader(String source, String charset) {
        this(Defines.createEmpty(), source, "UTF-8", Collections.emptyList());
    }

    public SourceStringReader(Defines defines, String source, List<String> config) {
        this(defines, source, "UTF-8", config);
    }

    public SourceStringReader(Defines defines, String source) {
        this(defines, source, "UTF-8", Collections.emptyList());
    }

    public SourceStringReader(String source, File newCurrentDir) {
        this(Defines.createEmpty(), source, "UTF-8", Collections.emptyList(), newCurrentDir);
    }

    public SourceStringReader(Defines defines, String source, String charset, List<String> config) {
        this(defines, source, charset, config, FileSystem.getInstance().getCurrentDir());
    }

    public SourceStringReader(Defines defines, String source, String charset, List<String> config, File newCurrentDir) {
        try {
            BlockUmlBuilder builder = new BlockUmlBuilder(config, charset, defines, new StringReader(source), newCurrentDir, "string");
            this.blocks = builder.getBlockUmls();
        }
        catch (IOException e) {
            Log.error("error " + e);
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    public String generateImage(OutputStream os) throws IOException {
        return this.outputImage(os).getDescription();
    }

    public DiagramDescription outputImage(OutputStream os) throws IOException {
        return this.outputImage(os, 0);
    }

    @Deprecated
    public String generateImage(File f) throws IOException {
        return this.outputImage(f).getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagramDescription outputImage(File f) throws IOException {
        DiagramDescription result = null;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
            result = this.outputImage((OutputStream)os, 0);
        }
        return result;
    }

    @Deprecated
    public String generateImage(OutputStream os, FileFormatOption fileFormatOption) throws IOException {
        return this.outputImage(os, fileFormatOption).getDescription();
    }

    public DiagramDescription outputImage(OutputStream os, FileFormatOption fileFormatOption) throws IOException {
        return this.outputImage(os, 0, fileFormatOption);
    }

    @Deprecated
    public String generateImage(OutputStream os, int numImage) throws IOException {
        return this.outputImage(os, numImage).getDescription();
    }

    public DiagramDescription outputImage(OutputStream os, int numImage) throws IOException {
        return this.outputImage(os, numImage, new FileFormatOption(FileFormat.PNG));
    }

    @Deprecated
    public String generateImage(OutputStream os, int numImage, FileFormatOption fileFormatOption) throws IOException {
        return this.outputImage(os, numImage, fileFormatOption).getDescription();
    }

    public DiagramDescription outputImage(OutputStream os, int numImage, FileFormatOption fileFormatOption) throws IOException {
        if (this.blocks.size() == 0) {
            this.noStartumlFound(os, fileFormatOption, 42L);
            return null;
        }
        for (BlockUml b : this.blocks) {
            Diagram system = b.getDiagram();
            int nbInSystem = system.getNbImages();
            if (numImage < nbInSystem) {
                ImageData imageData = system.exportDiagram(os, numImage, fileFormatOption);
                return system.getDescription();
            }
            numImage -= nbInSystem;
        }
        Log.error("numImage is too big = " + numImage);
        return null;
    }

    public DiagramDescription generateDiagramDescription(int numImage, FileFormatOption fileFormatOption) {
        if (this.blocks.size() == 0) {
            return null;
        }
        for (BlockUml b : this.blocks) {
            Diagram system = b.getDiagram();
            int nbInSystem = system.getNbImages();
            if (numImage < nbInSystem) {
                return system.getDescription();
            }
            numImage -= nbInSystem;
        }
        Log.error("numImage is too big = " + numImage);
        return null;
    }

    public DiagramDescription generateDiagramDescription() {
        return this.generateDiagramDescription(0);
    }

    public DiagramDescription generateDiagramDescription(FileFormatOption fileFormatOption) {
        return this.generateDiagramDescription(0, fileFormatOption);
    }

    public DiagramDescription generateDiagramDescription(int numImage) {
        return this.generateDiagramDescription(numImage, new FileFormatOption(FileFormat.PNG));
    }

    public String getCMapData(int numImage, FileFormatOption fileFormatOption) throws IOException {
        if (this.blocks.size() == 0) {
            return null;
        }
        for (BlockUml b : this.blocks) {
            Diagram system = b.getDiagram();
            int nbInSystem = system.getNbImages();
            if (numImage < nbInSystem) {
                ImageData imageData = system.exportDiagram(new NullOutputStream(), numImage, fileFormatOption);
                if (imageData.containsCMapData()) {
                    return imageData.getCMapData("plantuml");
                }
                return null;
            }
            numImage -= nbInSystem;
        }
        return null;
    }

    private void noStartumlFound(OutputStream os, FileFormatOption fileFormatOption, long seed) throws IOException {
        IEntityImage error = GraphicStrings.createForError(Arrays.asList("No @startuml found"), fileFormatOption.isUseRedForError());
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, error.getBackcolor(), null, null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(error);
        imageBuilder.writeImageTOBEMOVED(fileFormatOption, seed, os);
    }

    public final List<BlockUml> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }
}

