"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setup = exports.HTML_CONTEXT_TYPE = void 0;

var _lodash = require("lodash");

var _utils = require("../utils");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const HTML_CONTEXT_TYPE = 'html';
exports.HTML_CONTEXT_TYPE = HTML_CONTEXT_TYPE;

const getConvertFn = (format, convert) => {
  const fallbackHtml = (value, field, hit) => {
    const formatted = (0, _lodash.escape)(format.convert(value, 'text'));
    return !field || !hit || !hit.highlight || !hit.highlight[field.name] ? formatted : (0, _utils.getHighlightHtml)(formatted, hit.highlight[field.name]);
  };

  return convert || fallbackHtml;
};

const setup = (format, htmlContextTypeConvert) => {
  const convert = getConvertFn(format, htmlContextTypeConvert);

  const recurse = (value, field, hit, meta) => {
    if (value == null) {
      return (0, _utils.asPrettyString)(value);
    }

    if (!value || !(0, _lodash.isFunction)(value.map)) {
      return convert.call(format, value, field, hit, meta);
    }

    const subValues = value.map(v => {
      return recurse(v, field, hit, meta);
    });
    const useMultiLine = subValues.some(sub => {
      return sub.indexOf('\n') > -1;
    });
    return subValues.join(',' + (useMultiLine ? '\n' : ' '));
  };

  const wrap = (value, field, hit, meta) => {
    return `<span ng-non-bindable>${recurse(value, field, hit, meta)}</span>`;
  };

  return wrap;
};

exports.setup = setup;