"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryOptInProvider = TelemetryOptInProvider;

var _moment = _interopRequireDefault(require("moment"));

var _ui_metric = require("ui/ui_metric");

var _notify = require("ui/notify");

var _new_platform = require("ui/new_platform");

var _i18n = require("@kbn/i18n");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var bannerId = null;
var optInBannerNoticeId = null;
var currentOptInStatus = false;
var telemetryNotifyUserAboutOptInDefault = true;

function sendOptInStatus(_x, _x2, _x3) {
  return _sendOptInStatus.apply(this, arguments);
}

function _sendOptInStatus() {
  _sendOptInStatus = _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee4($injector, chrome, enabled) {
    var telemetryOptInStatusUrl, $http, optInStatus;
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            telemetryOptInStatusUrl = _new_platform.npStart.core.injectedMetadata.getInjectedVar('telemetryOptInStatusUrl');
            $http = $injector.get('$http');
            _context4.prev = 2;
            _context4.next = 5;
            return $http.post(chrome.addBasePath('/api/telemetry/v2/clusters/_opt_in_stats'), {
              enabled: enabled,
              unencrypted: false
            });

          case 5:
            optInStatus = _context4.sent;

            if (!(optInStatus.data && optInStatus.data.length)) {
              _context4.next = 10;
              break;
            }

            _context4.next = 9;
            return fetch(telemetryOptInStatusUrl, {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json'
              },
              body: JSON.stringify(optInStatus.data)
            });

          case 9:
            return _context4.abrupt("return", _context4.sent);

          case 10:
            _context4.next = 14;
            break;

          case 12:
            _context4.prev = 12;
            _context4.t0 = _context4["catch"](2);

          case 14:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, null, [[2, 12]]);
  }));
  return _sendOptInStatus.apply(this, arguments);
}

function TelemetryOptInProvider($injector, chrome) {
  var sendOptInStatusChange = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
  currentOptInStatus = _new_platform.npStart.core.injectedMetadata.getInjectedVar('telemetryOptedIn');

  var allowChangingOptInStatus = _new_platform.npStart.core.injectedMetadata.getInjectedVar('allowChangingOptInStatus');

  telemetryNotifyUserAboutOptInDefault = _new_platform.npStart.core.injectedMetadata.getInjectedVar('telemetryNotifyUserAboutOptInDefault');
  (0, _ui_metric.setCanTrackUiMetrics)(currentOptInStatus);
  var provider = {
    getBannerId: function getBannerId() {
      return bannerId;
    },
    getOptInBannerNoticeId: function getOptInBannerNoticeId() {
      return optInBannerNoticeId;
    },
    getOptIn: function getOptIn() {
      return currentOptInStatus;
    },
    canChangeOptInStatus: function canChangeOptInStatus() {
      return allowChangingOptInStatus;
    },
    notifyUserAboutOptInDefault: function notifyUserAboutOptInDefault() {
      return telemetryNotifyUserAboutOptInDefault;
    },
    setBannerId: function setBannerId(id) {
      bannerId = id;
    },
    setOptInBannerNoticeId: function setOptInBannerNoticeId(id) {
      optInBannerNoticeId = id;
    },
    setOptInNoticeSeen: function () {
      var _setOptInNoticeSeen = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee() {
        var $http;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                $http = $injector.get('$http'); // If they've seen the notice don't spam the API

                if (telemetryNotifyUserAboutOptInDefault) {
                  _context.next = 3;
                  break;
                }

                return _context.abrupt("return", telemetryNotifyUserAboutOptInDefault);

              case 3:
                if (optInBannerNoticeId) {
                  _notify.banners.remove(optInBannerNoticeId);
                }

                _context.prev = 4;
                _context.next = 7;
                return $http.put(chrome.addBasePath('/api/telemetry/v2/userHasSeenNotice'));

              case 7:
                telemetryNotifyUserAboutOptInDefault = false;
                _context.next = 14;
                break;

              case 10:
                _context.prev = 10;
                _context.t0 = _context["catch"](4);

                _notify.toastNotifications.addError(_context.t0, {
                  title: _i18n.i18n.translate('telemetry.optInNoticeSeenErrorTitle', {
                    defaultMessage: 'Error'
                  }),
                  toastMessage: _i18n.i18n.translate('telemetry.optInNoticeSeenErrorToastText', {
                    defaultMessage: 'An error occurred dismissing the notice'
                  })
                });

                telemetryNotifyUserAboutOptInDefault = true;

              case 14:
                return _context.abrupt("return", telemetryNotifyUserAboutOptInDefault);

              case 15:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[4, 10]]);
      }));

      function setOptInNoticeSeen() {
        return _setOptInNoticeSeen.apply(this, arguments);
      }

      return setOptInNoticeSeen;
    }(),
    setOptIn: function () {
      var _setOptIn = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee2(enabled) {
        var $http;
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                if (allowChangingOptInStatus) {
                  _context2.next = 2;
                  break;
                }

                return _context2.abrupt("return");

              case 2:
                (0, _ui_metric.setCanTrackUiMetrics)(enabled);
                $http = $injector.get('$http');
                _context2.prev = 4;
                _context2.next = 7;
                return $http.post(chrome.addBasePath('/api/telemetry/v2/optIn'), {
                  enabled: enabled
                });

              case 7:
                if (!sendOptInStatusChange) {
                  _context2.next = 10;
                  break;
                }

                _context2.next = 10;
                return sendOptInStatus($injector, chrome, enabled);

              case 10:
                currentOptInStatus = enabled;
                _context2.next = 17;
                break;

              case 13:
                _context2.prev = 13;
                _context2.t0 = _context2["catch"](4);

                _notify.toastNotifications.addError(_context2.t0, {
                  title: _i18n.i18n.translate('telemetry.optInErrorToastTitle', {
                    defaultMessage: 'Error'
                  }),
                  toastMessage: _i18n.i18n.translate('telemetry.optInErrorToastText', {
                    defaultMessage: 'An error occurred while trying to set the usage statistics preference.'
                  })
                });

                return _context2.abrupt("return", false);

              case 17:
                return _context2.abrupt("return", true);

              case 18:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, null, [[4, 13]]);
      }));

      function setOptIn(_x4) {
        return _setOptIn.apply(this, arguments);
      }

      return setOptIn;
    }(),
    fetchExample: function () {
      var _fetchExample = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee3() {
        var $http;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                $http = $injector.get('$http');
                return _context3.abrupt("return", $http.post(chrome.addBasePath("/api/telemetry/v2/clusters/_stats"), {
                  unencrypted: true,
                  timeRange: {
                    min: (0, _moment.default)().subtract(20, 'minutes').toISOString(),
                    max: (0, _moment.default)().toISOString()
                  }
                }));

              case 2:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));

      function fetchExample() {
        return _fetchExample.apply(this, arguments);
      }

      return fetchExample;
    }()
  };
  return provider;
}