"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBoolFormat = createBoolFormat;

var _common = require("../../../../../../plugins/data/common");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function createBoolFormat() {
  var _class, _temp;

  return _temp = _class = class BoolFormat extends _common.FieldFormat {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "textConvert", value => {
        if (typeof value === 'string') {
          value = value.trim().toLowerCase();
        }

        switch (value) {
          case false:
          case 0:
          case 'false':
          case 'no':
            return 'false';

          case true:
          case 1:
          case 'true':
          case 'yes':
            return 'true';

          default:
            return (0, _common.asPrettyString)(value);
        }
      });
    }

  }, _defineProperty(_class, "id", 'boolean'), _defineProperty(_class, "title", 'Boolean'), _defineProperty(_class, "fieldType", [_common.KBN_FIELD_TYPES.BOOLEAN, _common.KBN_FIELD_TYPES.NUMBER, _common.KBN_FIELD_TYPES.STRING]), _temp;
}