"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomExtentsOptions = CustomExtentsOptions;

var _react = _interopRequireWildcard(require("react"));

var _i18n = require("@kbn/i18n");

var _common = require("../../common");

var _y_extents = require("./y_extents");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function CustomExtentsOptions(_ref) {
  var axis = _ref.axis,
      setMultipleValidity = _ref.setMultipleValidity,
      setValueAxis = _ref.setValueAxis,
      setValueAxisScale = _ref.setValueAxisScale;

  var _useState = (0, _react.useState)(true),
      _useState2 = _slicedToArray(_useState, 2),
      isBoundsMarginValid = _useState2[0],
      setIsBoundsMarginValid = _useState2[1];

  var invalidBoundsMarginMessage = _i18n.i18n.translate('kbnVislibVisTypes.controls.pointSeries.valueAxes.scaleToDataBounds.minNeededBoundsMargin', {
    defaultMessage: 'Bounds margin must be greater than or equal to 0.'
  });

  var setBoundsMargin = (0, _react.useCallback)(function (paramName, value) {
    var isValid = value === '' ? true : value >= 0;
    setIsBoundsMarginValid(isValid);
    setMultipleValidity('boundsMargin', isValid);
    setValueAxisScale(paramName, value);
  }, [setMultipleValidity, setValueAxisScale]);
  var onDefaultYExtentsChange = (0, _react.useCallback)(function (paramName, value) {
    var scale = _objectSpread({}, axis.scale, _defineProperty({}, paramName, value));

    if (!scale.defaultYExtents) {
      delete scale.boundsMargin;
      setMultipleValidity('boundsMargin', true);
    }

    setValueAxis('scale', scale);
  }, [setValueAxis, axis.scale]);
  var onSetYExtentsChange = (0, _react.useCallback)(function (paramName, value) {
    var scale = _objectSpread({}, axis.scale, _defineProperty({}, paramName, value));

    if (!scale.setYExtents) {
      delete scale.min;
      delete scale.max;
    }

    setValueAxis('scale', scale);
  }, [setValueAxis, axis.scale]);
  return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_common.SwitchOption, {
    label: _i18n.i18n.translate('kbnVislibVisTypes.controls.pointSeries.valueAxes.scaleToDataBoundsLabel', {
      defaultMessage: 'Scale to data bounds'
    }),
    paramName: "defaultYExtents",
    value: axis.scale.defaultYExtents,
    setValue: onDefaultYExtentsChange
  }), axis.scale.defaultYExtents && _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_common.NumberInputOption, {
    error: !isBoundsMarginValid && invalidBoundsMarginMessage,
    isInvalid: !isBoundsMarginValid,
    label: _i18n.i18n.translate('kbnVislibVisTypes.controls.pointSeries.valueAxes.scaleToDataBounds.boundsMargin', {
      defaultMessage: 'Bounds margin'
    }),
    step: 0.1,
    min: 0,
    paramName: "boundsMargin",
    value: axis.scale.boundsMargin,
    setValue: setBoundsMargin
  })), _react.default.createElement(_common.SwitchOption, {
    "data-test-subj": "yAxisSetYExtents",
    label: _i18n.i18n.translate('kbnVislibVisTypes.controls.pointSeries.valueAxes.setAxisExtentsLabel', {
      defaultMessage: 'Set axis extents'
    }),
    paramName: "setYExtents",
    value: axis.scale.setYExtents,
    setValue: onSetYExtentsChange
  }), axis.scale.setYExtents && _react.default.createElement(_y_extents.YExtents, {
    scale: axis.scale,
    setScale: setValueAxisScale,
    setMultipleValidity: setMultipleValidity
  }));
}