"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = render;
exports.ExpressionRenderHandler = void 0;

var Rx = _interopRequireWildcard(require("rxjs"));

var _operators = require("rxjs/operators");

var _services = require("./services");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var ExpressionRenderHandler = function ExpressionRenderHandler(element) {
  var _this = this;

  _classCallCheck(this, ExpressionRenderHandler);

  _defineProperty(this, "render$", void 0);

  _defineProperty(this, "update$", void 0);

  _defineProperty(this, "events$", void 0);

  _defineProperty(this, "element", void 0);

  _defineProperty(this, "destroyFn", void 0);

  _defineProperty(this, "renderCount", 0);

  _defineProperty(this, "renderSubject", void 0);

  _defineProperty(this, "eventsSubject", void 0);

  _defineProperty(this, "updateSubject", void 0);

  _defineProperty(this, "handlers", void 0);

  _defineProperty(this, "render", function (data) {
    var extraHandlers = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (!data || _typeof(data) !== 'object') {
      _this.renderSubject.next({
        type: 'error',
        error: {
          message: 'invalid data provided to the expression renderer'
        }
      });

      return;
    }

    if (data.type !== 'render' || !data.as) {
      if (data.type === 'error') {
        _this.renderSubject.next(data);
      } else {
        _this.renderSubject.next({
          type: 'error',
          error: {
            message: 'invalid data provided to the expression renderer'
          }
        });
      }

      return;
    }

    if (!(0, _services.getRenderersRegistry)().get(data.as)) {
      _this.renderSubject.next({
        type: 'error',
        error: {
          message: "invalid renderer id '".concat(data.as, "'")
        }
      });

      return;
    }

    try {
      // Rendering is asynchronous, completed by handlers.done()
      (0, _services.getRenderersRegistry)().get(data.as).render(_this.element, data.value, _objectSpread({}, _this.handlers, {}, extraHandlers));
    } catch (e) {
      _this.renderSubject.next({
        type: 'error',
        error: {
          type: e.type,
          message: e.message
        }
      });
    }
  });

  _defineProperty(this, "destroy", function () {
    _this.renderSubject.complete();

    _this.eventsSubject.complete();

    _this.updateSubject.complete();

    if (_this.destroyFn) {
      _this.destroyFn();
    }
  });

  _defineProperty(this, "getElement", function () {
    return _this.element;
  });

  this.element = element;
  this.eventsSubject = new Rx.Subject();
  this.events$ = this.eventsSubject.asObservable().pipe((0, _operators.share)());
  this.renderSubject = new Rx.Subject();
  this.render$ = this.renderSubject.asObservable().pipe((0, _operators.share)());
  this.updateSubject = new Rx.Subject();
  this.update$ = this.updateSubject.asObservable().pipe((0, _operators.share)());
  this.handlers = {
    onDestroy: function onDestroy(fn) {
      _this.destroyFn = fn;
    },
    done: function done() {
      _this.renderCount++;

      _this.renderSubject.next(_this.renderCount);
    },
    reload: function reload() {
      _this.updateSubject.next(null);
    },
    update: function update(params) {
      _this.updateSubject.next(params);
    },
    event: function event(data) {
      _this.eventsSubject.next(data);
    }
  };
};

exports.ExpressionRenderHandler = ExpressionRenderHandler;

function render(element, data) {
  var handler = new ExpressionRenderHandler(element);
  handler.render(data);
  return handler;
}