"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionRendererImplementation = void 0;

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _eui = require("@elastic/eui");

var _loader = require("./loader");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var defaultState = {
  isEmpty: true,
  isLoading: false,
  error: null
};

var ExpressionRendererImplementation = function ExpressionRendererImplementation(_ref) {
  var dataAttrs = _ref.dataAttrs,
      expression = _ref.expression,
      renderError = _ref.renderError,
      options = _objectWithoutProperties(_ref, ["dataAttrs", "expression", "renderError"]);

  var mountpoint = (0, _react.useRef)(null);
  var handlerRef = (0, _react.useRef)(null);

  var _useState = (0, _react.useState)(_objectSpread({}, defaultState)),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1]; // Re-fetch data automatically when the inputs change


  (0, _react.useEffect)(function () {
    if (handlerRef.current) {
      handlerRef.current.update(expression, options);
    }
  }, [expression, options.searchContext, options.context, options.variables, options.disableCaching]); // Initialize the loader only once

  (0, _react.useEffect)(function () {
    if (mountpoint.current && !handlerRef.current) {
      handlerRef.current = new _loader.ExpressionLoader(mountpoint.current, expression, options);
      handlerRef.current.loading$.subscribe(function () {
        if (!handlerRef.current) {
          return;
        }

        setState(function (prevState) {
          return _objectSpread({}, prevState, {
            isLoading: true
          });
        });
      });
      handlerRef.current.render$.subscribe(function (item) {
        if (!handlerRef.current) {
          return;
        }

        if (typeof item !== 'number') {
          setState(function () {
            return _objectSpread({}, defaultState, {
              isEmpty: false,
              error: item.error
            });
          });
        } else {
          setState(function () {
            return _objectSpread({}, defaultState, {
              isEmpty: false
            });
          });
        }
      });
    }
  }, [mountpoint.current]);
  (0, _react.useEffect)(function () {
    // We only want a clean up to run when the entire component is unloaded, not on every render
    return function cleanup() {
      if (handlerRef.current) {
        handlerRef.current.destroy();
        handlerRef.current = null;
      }
    };
  }, []);
  var classes = (0, _classnames.default)('expExpressionRenderer', {
    'expExpressionRenderer-isEmpty': state.isEmpty,
    'expExpressionRenderer-hasError': !!state.error
  });
  return _react.default.createElement("div", _extends({}, dataAttrs, {
    className: classes
  }), state.isEmpty ? _react.default.createElement(_eui.EuiLoadingChart, {
    mono: true,
    size: "l"
  }) : null, state.isLoading ? _react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }) : null, !state.isLoading && state.error ? renderError ? renderError(state.error.message) : _react.default.createElement("div", {
    "data-test-subj": "expression-renderer-error"
  }, state.error.message) : null, _react.default.createElement("div", {
    className: "expExpressionRenderer__expression",
    ref: mountpoint
  }));
};

exports.ExpressionRendererImplementation = ExpressionRendererImplementation;