"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataPlugin = void 0;

var _search = require("./search");

var _query = require("./query");

var _filter = require("./filter");

var _timefilter = require("./timefilter");

var _index_patterns = require("./index_patterns");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Data Plugin - public
 *
 * This is the entry point for the entire client-side public contract of the plugin.
 * If something is not explicitly exported here, you can safely assume it is private
 * to the plugin and not considered stable.
 *
 * All stateful contracts will be injected by the platform at runtime, and are defined
 * in the setup/start interfaces. The remaining items exported here are either types,
 * or static code.
 */
var DataPlugin =
/*#__PURE__*/
function () {
  function DataPlugin() {
    _classCallCheck(this, DataPlugin);

    _defineProperty(this, "filter", new _filter.FilterService());

    _defineProperty(this, "indexPatterns", new _index_patterns.IndexPatternsService());

    _defineProperty(this, "query", new _query.QueryService());

    _defineProperty(this, "search", new _search.SearchService());

    _defineProperty(this, "timefilter", new _timefilter.TimefilterService());

    _defineProperty(this, "setupApi", void 0);
  }

  _createClass(DataPlugin, [{
    key: "setup",
    value: function setup(core, _ref) {
      var __LEGACY = _ref.__LEGACY;
      var uiSettings = core.uiSettings;
      var timefilterService = this.timefilter.setup({
        uiSettings: uiSettings,
        store: __LEGACY.storage
      });
      var filterService = this.filter.setup({
        uiSettings: uiSettings
      });
      this.setupApi = {
        indexPatterns: this.indexPatterns.setup(),
        query: this.query.setup(),
        timefilter: timefilterService,
        filter: filterService
      };
      return this.setupApi;
    }
  }, {
    key: "start",
    value: function start(core, _ref2) {
      var __LEGACY = _ref2.__LEGACY,
          data = _ref2.data;
      var uiSettings = core.uiSettings,
          http = core.http,
          notifications = core.notifications,
          savedObjects = core.savedObjects;
      var indexPatternsService = this.indexPatterns.start({
        uiSettings: uiSettings,
        savedObjectsClient: savedObjects.client,
        http: http,
        notifications: notifications
      });
      var SearchBar = (0, _search.createSearchBar)({
        core: core,
        data: data,
        store: __LEGACY.storage,
        timefilter: this.setupApi.timefilter,
        filterManager: this.setupApi.filter.filterManager
      });
      return _objectSpread({}, this.setupApi, {
        indexPatterns: indexPatternsService,
        search: this.search.start(savedObjects.client),
        ui: {
          SearchBar: SearchBar
        }
      });
    }
  }, {
    key: "stop",
    value: function stop() {
      this.indexPatterns.stop();
      this.filter.stop();
      this.query.stop();
      this.search.stop();
      this.timefilter.stop();
    }
  }]);

  return DataPlugin;
}();

exports.DataPlugin = DataPlugin;