"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Field", {
  enumerable: true,
  get: function get() {
    return _fields.Field;
  }
});
Object.defineProperty(exports, "FieldListInterface", {
  enumerable: true,
  get: function get() {
    return _fields.FieldListInterface;
  }
});
Object.defineProperty(exports, "FieldType", {
  enumerable: true,
  get: function get() {
    return _fields.FieldType;
  }
});
Object.defineProperty(exports, "IndexPattern", {
  enumerable: true,
  get: function get() {
    return _index_patterns.IndexPattern;
  }
});
Object.defineProperty(exports, "IndexPatterns", {
  enumerable: true,
  get: function get() {
    return _index_patterns.IndexPatterns;
  }
});
Object.defineProperty(exports, "StaticIndexPattern", {
  enumerable: true,
  get: function get() {
    return _index_patterns.StaticIndexPattern;
  }
});
Object.defineProperty(exports, "IndexPatternSelect", {
  enumerable: true,
  get: function get() {
    return _components.IndexPatternSelect;
  }
});
Object.defineProperty(exports, "CONTAINS_SPACES", {
  enumerable: true,
  get: function get() {
    return _utils.CONTAINS_SPACES;
  }
});
Object.defineProperty(exports, "getFromSavedObject", {
  enumerable: true,
  get: function get() {
    return _utils.getFromSavedObject;
  }
});
Object.defineProperty(exports, "getRoutes", {
  enumerable: true,
  get: function get() {
    return _utils.getRoutes;
  }
});
Object.defineProperty(exports, "ILLEGAL_CHARACTERS", {
  enumerable: true,
  get: function get() {
    return _utils.ILLEGAL_CHARACTERS;
  }
});
Object.defineProperty(exports, "INDEX_PATTERN_ILLEGAL_CHARACTERS", {
  enumerable: true,
  get: function get() {
    return _utils.INDEX_PATTERN_ILLEGAL_CHARACTERS;
  }
});
Object.defineProperty(exports, "INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE", {
  enumerable: true,
  get: function get() {
    return _utils.INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE;
  }
});
Object.defineProperty(exports, "isFilterable", {
  enumerable: true,
  get: function get() {
    return _utils.isFilterable;
  }
});
Object.defineProperty(exports, "validateIndexPattern", {
  enumerable: true,
  get: function get() {
    return _utils.validateIndexPattern;
  }
});
Object.defineProperty(exports, "mockFields", {
  enumerable: true,
  get: function get() {
    return _utils.mockFields;
  }
});
Object.defineProperty(exports, "mockIndexPattern", {
  enumerable: true,
  get: function get() {
    return _utils.mockIndexPattern;
  }
});
Object.defineProperty(exports, "getIndexPatternTitle", {
  enumerable: true,
  get: function get() {
    return _utils.getIndexPatternTitle;
  }
});
Object.defineProperty(exports, "findIndexPatternByTitle", {
  enumerable: true,
  get: function get() {
    return _utils.findIndexPatternByTitle;
  }
});
Object.defineProperty(exports, "IndexPatternAlreadyExists", {
  enumerable: true,
  get: function get() {
    return _errors.IndexPatternAlreadyExists;
  }
});
Object.defineProperty(exports, "IndexPatternMissingIndices", {
  enumerable: true,
  get: function get() {
    return _errors.IndexPatternMissingIndices;
  }
});
Object.defineProperty(exports, "NoDefaultIndexPattern", {
  enumerable: true,
  get: function get() {
    return _errors.NoDefaultIndexPattern;
  }
});
Object.defineProperty(exports, "NoDefinedIndexPatterns", {
  enumerable: true,
  get: function get() {
    return _errors.NoDefinedIndexPatterns;
  }
});
exports.IndexPatternsService = void 0;

var _fields = require("./fields");

var _index_patterns = require("./index_patterns");

var _components = require("./components");

var _utils = require("./utils");

var _errors = require("./errors");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Index Patterns Service
 *
 * @internal
 */
var IndexPatternsService =
/*#__PURE__*/
function () {
  function IndexPatternsService() {
    _classCallCheck(this, IndexPatternsService);

    _defineProperty(this, "setupApi", void 0);
  }

  _createClass(IndexPatternsService, [{
    key: "setup",
    value: function setup() {
      this.setupApi = {
        FieldList: _fields.FieldList,
        flattenHitWrapper: (0, _index_patterns.createFlattenHitWrapper)(),
        formatHitProvider: _index_patterns.formatHitProvider,
        __LEGACY: {
          // For BWC we must temporarily export the class implementation of Field,
          // which is only used externally by the Index Pattern UI.
          FieldImpl: _fields.Field
        }
      };
      return this.setupApi;
    }
  }, {
    key: "start",
    value: function start(_ref) {
      var uiSettings = _ref.uiSettings,
          savedObjectsClient = _ref.savedObjectsClient,
          http = _ref.http,
          notifications = _ref.notifications;
      return _objectSpread({}, this.setupApi, {
        indexPatterns: new _index_patterns.IndexPatterns(uiSettings, savedObjectsClient, http, notifications),
        IndexPatternSelect: (0, _components.createIndexPatternSelect)(savedObjectsClient)
      });
    }
  }, {
    key: "stop",
    value: function stop() {// nothing to do here yet
    }
  }]);

  return IndexPatternsService;
}(); // static code

/** @public */


exports.IndexPatternsService = IndexPatternsService;