"use strict";

require("brace");

require("brace/ext/language_tools");

require("brace/ext/searchbox");

require("brace/mode/json");

require("brace/mode/text");

var _notify = require("ui/notify");

var _new_platform = require("ui/new_platform");

var _routes = _interopRequireDefault(require("ui/routes"));

var _documentation_links = require("ui/documentation_links");

var _i18n = require("ui/i18n");

var _resize_checker = require("ui/resize_checker");

require("ui/autoload/styles");

require("ui/capabilities/route_setup");

var _index = _interopRequireDefault(require("../../public/quarantined/index.html"));

var _ = require(".");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var pluginInstance = (0, _.plugin)({});
var anyObject = {};

_routes.default.when('/dev_tools/console', {
  requireUICapability: 'dev_tools.show',
  controller: function RootController($scope) {
    // Stub out this config for now...
    $scope.topNavMenu = [];

    $scope.initReactApp = function () {
      var targetElement = document.querySelector('#consoleRoot');

      if (!targetElement) {
        var message = "Could not mount Console App!";

        _new_platform.npSetup.core.fatalErrors.add(message);

        throw new Error(message);
      }

      var unmount;

      var mockedSetupCore = _objectSpread({}, _new_platform.npSetup.core, {
        notifications: _notify.toastNotifications,
        application: {
          register: function register(app) {
            try {
              unmount = app.mount(anyObject, {
                element: targetElement,
                appBasePath: ''
              });
            } catch (e) {
              _new_platform.npSetup.core.fatalErrors.add(e);
            }
          },
          registerMountContext: function registerMountContext() {}
        }
      });

      pluginInstance.setup(mockedSetupCore, _objectSpread({}, _new_platform.npSetup.plugins, {
        __LEGACY: {
          I18nContext: _i18n.I18nContext,
          ResizeChecker: _resize_checker.ResizeChecker,
          docLinkVersion: _documentation_links.DOC_LINK_VERSION
        }
      }));
      pluginInstance.start(_new_platform.npStart.core);
      $scope.$on('$destroy',
      /*#__PURE__*/
      _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee() {
        var fn;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                if (!unmount) {
                  _context.next = 5;
                  break;
                }

                _context.next = 3;
                return unmount;

              case 3:
                fn = _context.sent;
                fn();

              case 5:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      })));
    };
  },
  template: _index.default
});