"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObjectsClientStub = createObjectsClientStub;
exports.savedObjectsClientErrors = void 0;

var _sinon = _interopRequireDefault(require("sinon"));

var _saved_objects = require("../saved_objects");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const savedObjectsClientErrors = _saved_objects.SavedObjectsClient.errors;
exports.savedObjectsClientErrors = savedObjectsClientErrors;

function createObjectsClientStub(esDocSource = {}) {
  const savedObjectsClient = {
    update: _sinon.default.stub(),
    get: _sinon.default.stub().returns({
      attributes: esDocSource
    }),
    create: _sinon.default.stub(),
    errors: savedObjectsClientErrors,
    bulkCreate: _sinon.default.stub(),
    bulkGet: _sinon.default.stub(),
    delete: _sinon.default.stub(),
    find: _sinon.default.stub()
  };
  return savedObjectsClient;
}