
/**
 * Kibana entry file
 *
 * This is programmatically created and updated, do not modify
 *
 * context: {
  "appExtensions": {
    "devTools": [
      "absolute:src/legacy/core_plugins/console/np_ready/public/legacy"
    ],
    "docViews": [
      "plugins/kbn_doc_views/kbn_doc_views"
    ],
    "embeddableFactories": [
      "plugins/kibana/discover/embeddable/search_embeddable_factory",
      "plugins/kibana/visualize/embeddable/visualize_embeddable_factory"
    ],
    "fieldFormatEditors": [
      "ui/field_editor/components/field_format_editor/register"
    ],
    "fieldFormats": [
      "plugins/kibana/field_formats/register"
    ],
    "hacks": [
      "absolute:src/legacy/core_plugins/region_map/public/legacy",
      "absolute:src/legacy/core_plugins/tile_map/public/legacy",
      "absolute:src/legacy/core_plugins/timelion/public/legacy",
      "absolute:src/legacy/core_plugins/vis_type_markdown/public/legacy",
      "absolute:src/legacy/core_plugins/vis_type_metric/public/legacy",
      "absolute:src/legacy/core_plugins/vis_type_table/public/legacy",
      "absolute:src/legacy/core_plugins/vis_type_tagcloud/public/legacy",
      "absolute:src/legacy/core_plugins/vis_type_timeseries/public/legacy",
      "absolute:src/legacy/core_plugins/vis_type_vega/public/legacy",
      "plugins/console/quarantined/hacks/register",
      "plugins/dashboard_embeddable_container/initialize",
      "plugins/kibana/dev_tools/hacks/hide_empty_tools",
      "plugins/telemetry/hacks/telemetry_init",
      "plugins/telemetry/hacks/telemetry_opt_in",
      "plugins/ui_metric/hacks/ui_metric_init"
    ],
    "interpreter": [
      "plugins/input_control_vis/input_control_fn",
      "plugins/kbn_vislib_vis_types/pie_fn",
      "plugins/kbn_vislib_vis_types/vislib_fn"
    ],
    "managementSections": [
      "plugins/telemetry/views/management"
    ],
    "savedObjectTypes": [
      "plugins/kibana/dashboard/saved_dashboard/saved_dashboard_register",
      "plugins/kibana/discover/saved_searches/saved_search_register",
      "plugins/kibana/visualize/saved_visualizations/saved_visualization_register"
    ],
    "search": [
      "ui/courier/search_strategy/default_search_strategy"
    ],
    "visEditorTypes": [
      "ui/vis/editors/default/default"
    ],
    "visTypes": [
      "plugins/input_control_vis/register_vis",
      "plugins/kbn_vislib_vis_types/kbn_vislib_vis_types"
    ]
  },
  "buildNum": 27521,
  "env": "production",
  "kbnVersion": "7.5.0"
}
 */

// import global polyfills
import Symbol_observable from 'symbol-observable';
import 'core-js/stable';
import 'regenerator-runtime/runtime';
import 'custom-event-polyfill';
import 'whatwg-fetch';
import 'abortcontroller-polyfill';
import 'childnode-remove-polyfill';

import { i18n } from '@kbn/i18n';
import { CoreSystem } from '__kibanaCore__'

const injectedMetadata = JSON.parse(document.querySelector('kbn-injected-metadata').getAttribute('data'));

i18n.load(injectedMetadata.i18n.translationsUrl)
  .catch(e => e)
  .then((i18nError) => {
    const coreSystem = new CoreSystem({
      injectedMetadata,
      rootDomElement: document.body,
      browserSupportsCsp: !window.__kbnCspNotEnforced__,
      requireLegacyFiles: () => {
        require('plugins/kibana/kibana');
      }
    });

    coreSystem
      .setup()
      .then((coreSetup) => {
        if (i18nError) {
          coreSetup.fatalErrors.add(i18nError);
        }

        return coreSystem.start();
      });
  });
