'use strict';
var $ = require('../internals/export');
var arrayMethods = require('../internals/array-methods');
var arrayMethodHasSpeciesSupport = require('../internals/array-method-has-species-support');

var internalMap = arrayMethods(1);
var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('map');

// `Array.prototype.map` method
// https://tc39.github.io/ecma262/#sec-array.prototype.map
// with adding support of @@species
$({ target: 'Array', proto: true, forced: !SPECIES_SUPPORT }, {
  map: function map(callbackfn /* , thisArg */) {
    return internalMap(this, callbackfn, arguments[1]);
  }
});
