/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.DbDirectoryTreeNode;
import org.linuxsampler.lscp.DbDirectoryInfo;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.Parser;
import org.linuxsampler.lscp.event.InstrumentsDbEvent;
import org.linuxsampler.lscp.event.InstrumentsDbListener;

public class InstrumentsDbTableModel
extends AbstractTableModel {
    private Vector<ColumnType> columns = new Vector();
    private boolean showSizeColumn = true;
    private boolean showFormatFamilyColumn = true;
    private boolean showFormatVersionColumn = false;
    private boolean showIsDrumColumn = false;
    private boolean showCreatedColumn = false;
    private boolean showModifiedColumn = true;
    private boolean showProductColumn = false;
    private boolean showArtistsColumn = false;
    private boolean showInstrumentFileColumn = false;
    private boolean showInstrumentNrColumn = false;
    private boolean showKeywordsColumn = false;
    private boolean showDummyColumn = false;
    private DbDirectoryTreeNode directoryNode;
    private NameComparator nameComparator = new NameComparator();
    private DateComparator dateComparator = new DateComparator();
    private SizeComparator sizeComparator = new SizeComparator();
    private NumberComparator numberComparator = new NumberComparator();
    private String renamedInstrument = null;
    private String renamedDirectory = null;
    private final EventHandler eventHandler = new EventHandler();

    public InstrumentsDbTableModel() {
        this(null);
    }

    public InstrumentsDbTableModel(DbDirectoryTreeNode dbDirectoryTreeNode) {
        this.directoryNode = dbDirectoryTreeNode;
        this.updateColumns();
    }

    public ColumnType getColumnType(int n) {
        return this.columns.get(n);
    }

    public int getDummyColumnIndex() {
        return this.columns.indexOf((Object)ColumnType.DUMMY);
    }

    public void showNameColumnOnly() {
        this.showSizeColumn = false;
        this.showFormatFamilyColumn = false;
        this.showFormatVersionColumn = false;
        this.showIsDrumColumn = false;
        this.showCreatedColumn = false;
        this.showModifiedColumn = false;
        this.showProductColumn = false;
        this.showArtistsColumn = false;
        this.showInstrumentFileColumn = false;
        this.showInstrumentNrColumn = false;
        this.showKeywordsColumn = false;
        this.updateColumns();
    }

    public boolean getShowSizeColumn() {
        return this.showSizeColumn;
    }

    public void setShowSizeColumn(boolean bl) {
        if (bl == this.showSizeColumn) {
            return;
        }
        this.showSizeColumn = bl;
        this.updateColumns();
    }

    public boolean getShowFormatFamilyColumn() {
        return this.showFormatFamilyColumn;
    }

    public void setShowFormatFamilyColumn(boolean bl) {
        if (bl == this.showFormatFamilyColumn) {
            return;
        }
        this.showFormatFamilyColumn = bl;
        this.updateColumns();
    }

    public boolean getShowFormatVersionColumn() {
        return this.showFormatVersionColumn;
    }

    public void setShowFormatVersionColumn(boolean bl) {
        if (bl == this.showFormatVersionColumn) {
            return;
        }
        this.showFormatVersionColumn = bl;
        this.updateColumns();
    }

    public boolean getShowIsDrumColumn() {
        return this.showIsDrumColumn;
    }

    public void setShowIsDrumColumn(boolean bl) {
        if (bl == this.showIsDrumColumn) {
            return;
        }
        this.showIsDrumColumn = bl;
        this.updateColumns();
    }

    public boolean getShowCreatedColumn() {
        return this.showCreatedColumn;
    }

    public void setShowCreatedColumn(boolean bl) {
        if (bl == this.showCreatedColumn) {
            return;
        }
        this.showCreatedColumn = bl;
        this.updateColumns();
    }

    public boolean getShowModifiedColumn() {
        return this.showModifiedColumn;
    }

    public void setShowModifiedColumn(boolean bl) {
        if (bl == this.showModifiedColumn) {
            return;
        }
        this.showModifiedColumn = bl;
        this.updateColumns();
    }

    public boolean getShowProductColumn() {
        return this.showProductColumn;
    }

    public void setShowProductColumn(boolean bl) {
        if (bl == this.showProductColumn) {
            return;
        }
        this.showProductColumn = bl;
        this.updateColumns();
    }

    public boolean getShowArtistsColumn() {
        return this.showArtistsColumn;
    }

    public void setShowArtistsColumn(boolean bl) {
        if (bl == this.showArtistsColumn) {
            return;
        }
        this.showArtistsColumn = bl;
        this.updateColumns();
    }

    public boolean getShowInstrumentFileColumn() {
        return this.showInstrumentFileColumn;
    }

    public void setShowInstrumentFileColumn(boolean bl) {
        if (bl == this.showInstrumentFileColumn) {
            return;
        }
        this.showInstrumentFileColumn = bl;
        this.updateColumns();
    }

    public boolean getShowInstrumentNrColumn() {
        return this.showInstrumentNrColumn;
    }

    public void setShowInstrumentNrColumn(boolean bl) {
        if (bl == this.showInstrumentNrColumn) {
            return;
        }
        this.showInstrumentNrColumn = bl;
        this.updateColumns();
    }

    public boolean getShowKeywordsColumn() {
        return this.showKeywordsColumn;
    }

    public void setShowKeywordsColumn(boolean bl) {
        if (bl == this.showKeywordsColumn) {
            return;
        }
        this.showKeywordsColumn = bl;
        this.updateColumns();
    }

    public boolean getShowDummyColumn() {
        return this.showDummyColumn;
    }

    public void setShowDummyColumn(boolean bl) {
        if (bl == this.showDummyColumn) {
            return;
        }
        this.showDummyColumn = bl;
        this.updateColumns();
    }

    public Comparator getComparator(int n) {
        if (this.columns.get(n) == ColumnType.NAME) {
            return this.nameComparator;
        }
        if (this.columns.get(n) == ColumnType.CREATED) {
            return this.dateComparator;
        }
        if (this.columns.get(n) == ColumnType.MODIFIED) {
            return this.dateComparator;
        }
        if (this.columns.get(n) == ColumnType.SIZE) {
            return this.sizeComparator;
        }
        if (this.columns.get(n) == ColumnType.INSTRUMENT_NR) {
            return this.numberComparator;
        }
        return null;
    }

    public boolean isSortable(int n) {
        return this.columns.get(n) != ColumnType.DUMMY;
    }

    private void updateColumns() {
        this.columns.removeAllElements();
        this.columns.add(ColumnType.NAME);
        if (this.showSizeColumn) {
            this.columns.add(ColumnType.SIZE);
        }
        if (this.showFormatFamilyColumn) {
            this.columns.add(ColumnType.FORMAT_FAMILY);
        }
        if (this.showFormatVersionColumn) {
            this.columns.add(ColumnType.FORMAT_VERSION);
        }
        if (this.showIsDrumColumn) {
            this.columns.add(ColumnType.IS_DRUM);
        }
        if (this.showCreatedColumn) {
            this.columns.add(ColumnType.CREATED);
        }
        if (this.showModifiedColumn) {
            this.columns.add(ColumnType.MODIFIED);
        }
        if (this.showProductColumn) {
            this.columns.add(ColumnType.PRODUCT);
        }
        if (this.showArtistsColumn) {
            this.columns.add(ColumnType.ARTISTS);
        }
        if (this.showInstrumentFileColumn) {
            this.columns.add(ColumnType.INSTRUMENT_FILE);
        }
        if (this.showInstrumentNrColumn) {
            this.columns.add(ColumnType.INSTRUMENT_NR);
        }
        if (this.showKeywordsColumn) {
            this.columns.add(ColumnType.KEYWORDS);
        }
        if (this.showDummyColumn) {
            this.columns.add(ColumnType.DUMMY);
        }
        this.fireTableStructureChanged();
    }

    protected DbDirectoryTreeNode getParentDirectoryNode() {
        return this.directoryNode;
    }

    protected void setParentDirectoryNode(DbDirectoryTreeNode dbDirectoryTreeNode) {
        if (this.directoryNode != null) {
            this.directoryNode.removeInstrumentsDbListener(this.getHandler());
        }
        this.directoryNode = dbDirectoryTreeNode;
        if (this.directoryNode != null) {
            this.directoryNode.addInstrumentsDbListener(this.getHandler());
        }
        this.fireTableDataChanged();
    }

    public String getRenamedInstrument() {
        return this.renamedInstrument;
    }

    public void setRenamedInstrument(String string) {
        this.renamedInstrument = string;
    }

    public String getRenamedDirectory() {
        return this.renamedDirectory;
    }

    public void setRenamedDirectory(String string) {
        this.renamedDirectory = string;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        if (this.directoryNode == null) {
            return 0;
        }
        return this.directoryNode.getChildCount() + this.directoryNode.getInstrumentCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.columns.get(n).toString();
    }

    public DbDirectoryTreeNode getDirectoryNode(int n) {
        if (this.directoryNode == null) {
            return null;
        }
        if (n >= this.directoryNode.getChildCount()) {
            return null;
        }
        return this.directoryNode.getChildAt(n);
    }

    public DbInstrumentInfo getInstrument(int n) {
        if ((n -= this.directoryNode.getChildCount()) < 0) {
            return null;
        }
        return this.directoryNode.getInstrumentAt(n);
    }

    public int getDirectoryRowIndex(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.directoryNode.getChildCount(); ++i) {
            if (!string.equals(this.directoryNode.getChildAt(i).getInfo().getName())) continue;
            return i;
        }
        return -1;
    }

    public int getInstrumentRowIndex(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this.directoryNode.getInstrumentCount(); ++i) {
            if (!string.equals(this.directoryNode.getInstrumentAt(i).getName())) continue;
            return i + this.directoryNode.getChildCount();
        }
        return -1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.directoryNode.getChildCount() > n) {
            DbDirectoryInfo dbDirectoryInfo = this.directoryNode.getChildAt(n).getInfo();
            if (this.columns.get(n2) == ColumnType.NAME) {
                return dbDirectoryInfo;
            }
            if (this.columns.get(n2) == ColumnType.MODIFIED) {
                return dbDirectoryInfo.getDateModified();
            }
            if (this.columns.get(n2) == ColumnType.CREATED) {
                return dbDirectoryInfo.getDateCreated();
            }
            return "";
        }
        DbInstrumentInfo dbInstrumentInfo = this.directoryNode.getInstrumentAt(n - this.directoryNode.getChildCount());
        switch (this.columns.get(n2)) {
            case NAME: {
                return dbInstrumentInfo;
            }
            case SIZE: {
                return new InstrumentSize(dbInstrumentInfo);
            }
            case FORMAT_FAMILY: {
                return dbInstrumentInfo.getFormatFamily();
            }
            case FORMAT_VERSION: {
                return dbInstrumentInfo.getFormatVersion();
            }
            case IS_DRUM: {
                if (dbInstrumentInfo.isDrum()) {
                    return JSI18n.i18n.getLabel("InstrumentsDbTableModel.drumkit");
                }
                return JSI18n.i18n.getLabel("InstrumentsDbTableModel.chromatic");
            }
            case CREATED: {
                return dbInstrumentInfo.getDateCreated();
            }
            case MODIFIED: {
                return dbInstrumentInfo.getDateModified();
            }
            case PRODUCT: {
                return dbInstrumentInfo.getProduct();
            }
            case ARTISTS: {
                return dbInstrumentInfo.getArtists();
            }
            case INSTRUMENT_FILE: {
                return dbInstrumentInfo.getFilePath();
            }
            case INSTRUMENT_NR: {
                return dbInstrumentInfo.getInstrumentIndex();
            }
            case KEYWORDS: {
                return dbInstrumentInfo.getKeywords();
            }
            case DUMMY: {
                return "";
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, final int n, final int n2) {
        String string = object.toString();
        if (this.directoryNode.getChildCount() > n) {
            final DbDirectoryInfo dbDirectoryInfo = this.directoryNode.getChildAt(n).getInfo();
            final String string2 = dbDirectoryInfo.getName();
            if (string2.equals(string)) {
                return;
            }
            final InstrumentsDb.RenameDirectory renameDirectory = new InstrumentsDb.RenameDirectory(dbDirectoryInfo.getDirectoryPath(), string);
            dbDirectoryInfo.setName(string);
            this.setRenamedDirectory(dbDirectoryInfo.getName());
            this.fireTableCellUpdated(n, n2);
            renameDirectory.addTaskListener(new TaskListener(){

                @Override
                public void taskPerformed(TaskEvent taskEvent) {
                    if (!renameDirectory.doneWithErrors()) {
                        return;
                    }
                    dbDirectoryInfo.setName(string2);
                    InstrumentsDbTableModel.this.fireTableCellUpdated(n, n2);
                }
            });
            CC.getTaskQueue().add(renameDirectory);
            return;
        }
        final DbInstrumentInfo dbInstrumentInfo = this.directoryNode.getInstrumentAt(n - this.directoryNode.getChildCount());
        final String string3 = dbInstrumentInfo.getName();
        if (string3.equals(string)) {
            return;
        }
        final InstrumentsDb.RenameInstrument renameInstrument = new InstrumentsDb.RenameInstrument(dbInstrumentInfo.getInstrumentPath(), string);
        dbInstrumentInfo.setName(string);
        this.setRenamedInstrument(dbInstrumentInfo.getName());
        this.fireTableCellUpdated(n, n2);
        renameInstrument.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (!renameInstrument.doneWithErrors()) {
                    return;
                }
                dbInstrumentInfo.setName(string3);
                InstrumentsDbTableModel.this.fireTableCellUpdated(n, n2);
            }
        });
        CC.getTaskQueue().add(renameInstrument);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.columns.get(n2) == ColumnType.NAME;
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    implements InstrumentsDbListener {
        private EventHandler() {
        }

        @Override
        public void directoryCountChanged(InstrumentsDbEvent instrumentsDbEvent) {
            InstrumentsDbTableModel.this.fireTableDataChanged();
        }

        @Override
        public void directoryInfoChanged(InstrumentsDbEvent instrumentsDbEvent) {
        }

        @Override
        public void directoryNameChanged(InstrumentsDbEvent instrumentsDbEvent) {
            int n;
            String string = instrumentsDbEvent.getPathName();
            DbDirectoryInfo dbDirectoryInfo = InstrumentsDbTableModel.this.getParentDirectoryNode().getInfo();
            if (dbDirectoryInfo == null || !string.startsWith(dbDirectoryInfo.getDirectoryPath())) {
                return;
            }
            if ((string = string.substring(dbDirectoryInfo.getDirectoryPath().length(), string.length())).length() == 0) {
                return;
            }
            if (string.charAt(0) == '/') {
                string = string.substring(1, string.length());
            }
            if ((n = InstrumentsDbTableModel.this.getDirectoryRowIndex(Parser.toNonEscapedFileName(string))) == -1) {
                return;
            }
            InstrumentsDbTableModel.this.fireTableRowsUpdated(n, n);
        }

        @Override
        public void instrumentCountChanged(InstrumentsDbEvent instrumentsDbEvent) {
            InstrumentsDbTableModel.this.fireTableDataChanged();
        }

        @Override
        public void instrumentInfoChanged(InstrumentsDbEvent instrumentsDbEvent) {
            int n;
            String string = instrumentsDbEvent.getPathName();
            DbDirectoryInfo dbDirectoryInfo = InstrumentsDbTableModel.this.getParentDirectoryNode().getInfo();
            if (dbDirectoryInfo == null || !string.startsWith(dbDirectoryInfo.getDirectoryPath())) {
                return;
            }
            if ((string = string.substring(dbDirectoryInfo.getDirectoryPath().length(), string.length())).length() == 0) {
                return;
            }
            if (string.charAt(0) == '/') {
                string = string.substring(1, string.length());
            }
            if ((n = InstrumentsDbTableModel.this.getInstrumentRowIndex(string)) == -1) {
                return;
            }
            InstrumentsDbTableModel.this.fireTableRowsUpdated(n, n);
        }

        @Override
        public void instrumentNameChanged(InstrumentsDbEvent instrumentsDbEvent) {
        }

        @Override
        public void jobStatusChanged(InstrumentsDbEvent instrumentsDbEvent) {
        }
    }

    private class InstrumentSize {
        private DbInstrumentInfo instrument;

        InstrumentSize(DbInstrumentInfo dbInstrumentInfo) {
            this.instrument = dbInstrumentInfo;
        }

        public long getSize() {
            return this.instrument.getSize();
        }

        public String toString() {
            return this.instrument.getFormatedSize();
        }
    }

    private class NumberComparator
    implements Comparator {
        private NumberComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof Integer && object2 instanceof Integer) {
                int n;
                int n2 = (Integer)object;
                if (n2 < (n = ((Integer)object2).intValue())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }
            return object.toString().compareToIgnoreCase(object2.toString());
        }
    }

    private class SizeComparator
    implements Comparator {
        private SizeComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof InstrumentSize && object2 instanceof InstrumentSize) {
                long l;
                long l2 = ((InstrumentSize)object).getSize();
                if (l2 < (l = ((InstrumentSize)object2).getSize())) {
                    return -1;
                }
                if (l2 > l) {
                    return 1;
                }
                return 0;
            }
            return object.toString().compareToIgnoreCase(object2.toString());
        }
    }

    private class DateComparator
    implements Comparator {
        private DateComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof Date && object2 instanceof Date) {
                return ((Date)object).compareTo((Date)object2);
            }
            return object.toString().compareToIgnoreCase(object2.toString());
        }
    }

    private class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof DbInstrumentInfo && object2 instanceof DbDirectoryInfo) {
                return 1;
            }
            if (object instanceof DbDirectoryInfo && object2 instanceof DbInstrumentInfo) {
                return -1;
            }
            return object.toString().compareToIgnoreCase(object2.toString());
        }
    }

    public static enum ColumnType {
        NAME(JSI18n.i18n.getLabel("InstrumentsDbTableModel.NAME")),
        SIZE(JSI18n.i18n.getLabel("InstrumentsDbTableModel.SIZE")),
        FORMAT_FAMILY(JSI18n.i18n.getLabel("InstrumentsDbTableModel.FORMAT_FAMILY")),
        FORMAT_VERSION(JSI18n.i18n.getLabel("InstrumentsDbTableModel.FORMAT_VERSION")),
        IS_DRUM(JSI18n.i18n.getLabel("InstrumentsDbTableModel.IS_DRUM")),
        CREATED(JSI18n.i18n.getLabel("InstrumentsDbTableModel.CREATED")),
        MODIFIED(JSI18n.i18n.getLabel("InstrumentsDbTableModel.MODIFIED")),
        PRODUCT(JSI18n.i18n.getLabel("InstrumentsDbTableModel.PRODUCT")),
        ARTISTS(JSI18n.i18n.getLabel("InstrumentsDbTableModel.ARTISTS")),
        INSTRUMENT_FILE(JSI18n.i18n.getLabel("InstrumentsDbTableModel.INSTRUMENT_FILE")),
        INSTRUMENT_NR(JSI18n.i18n.getLabel("InstrumentsDbTableModel.INSTRUMENT_NR")),
        KEYWORDS(JSI18n.i18n.getLabel("InstrumentsDbTableModel.KEYWORDS")),
        DUMMY("");

        private final String name;

        private ColumnType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

