/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.UnionVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;

public class DefaultResolvedVersionConstraint
implements ResolvedVersionConstraint {
    private final VersionSelector preferredVersionSelector;
    private final VersionSelector requiredVersionSelector;
    private final VersionSelector rejectedVersionsSelector;
    private final boolean isStrict;
    private final boolean rejectAll;
    private final boolean isDynamic;

    public DefaultResolvedVersionConstraint(VersionConstraint parent, VersionSelectorScheme scheme) {
        this(parent.getRequiredVersion(), parent.getPreferredVersion(), parent.getStrictVersion(), parent.getRejectedVersions(), scheme);
    }

    @VisibleForTesting
    public DefaultResolvedVersionConstraint(String requiredVersion, String preferredVersion, String strictVersion, List<String> rejectedVersions, VersionSelectorScheme scheme) {
        this.isStrict = !strictVersion.isEmpty();
        String version = this.isStrict ? strictVersion : requiredVersion;
        this.requiredVersionSelector = scheme.parseSelector(version);
        VersionSelector versionSelector = this.preferredVersionSelector = preferredVersion.isEmpty() ? null : scheme.parseSelector(preferredVersion);
        if (this.isStrict) {
            VersionSelector rejectionForStrict = DefaultResolvedVersionConstraint.getRejectionForStrict(version, scheme);
            if (!rejectedVersions.isEmpty()) {
                VersionSelector explicitRejected = DefaultResolvedVersionConstraint.toRejectSelector(scheme, rejectedVersions);
                this.rejectedVersionsSelector = new UnionVersionSelector((List<VersionSelector>)ImmutableList.of((Object)rejectionForStrict, (Object)explicitRejected));
            } else {
                this.rejectedVersionsSelector = rejectionForStrict;
            }
            this.rejectAll = false;
        } else {
            this.rejectedVersionsSelector = DefaultResolvedVersionConstraint.toRejectSelector(scheme, rejectedVersions);
            this.rejectAll = DefaultResolvedVersionConstraint.isRejectAll(version, rejectedVersions);
        }
        this.isDynamic = this.doComputeIsDynamic();
    }

    private static VersionSelector getRejectionForStrict(String version, VersionSelectorScheme versionSelectorScheme) {
        VersionSelector preferredSelector = versionSelectorScheme.parseSelector(version);
        return versionSelectorScheme.complementForRejection(preferredSelector);
    }

    private static VersionSelector toRejectSelector(VersionSelectorScheme scheme, List<String> rejectedVersions) {
        if (rejectedVersions.size() > 1) {
            return UnionVersionSelector.of(rejectedVersions, scheme);
        }
        return rejectedVersions.isEmpty() ? null : scheme.parseSelector(rejectedVersions.get(0));
    }

    @Override
    public VersionSelector getPreferredSelector() {
        return this.preferredVersionSelector;
    }

    @Override
    public VersionSelector getRequiredSelector() {
        return this.requiredVersionSelector;
    }

    @Override
    public VersionSelector getRejectedSelector() {
        return this.rejectedVersionsSelector;
    }

    @Override
    public boolean isRejectAll() {
        return this.rejectAll;
    }

    @Override
    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public boolean isStrict() {
        return this.isStrict;
    }

    private boolean doComputeIsDynamic() {
        if (this.requiredVersionSelector != null) {
            return this.requiredVersionSelector.isDynamic();
        }
        if (this.preferredVersionSelector != null) {
            return this.preferredVersionSelector.isDynamic();
        }
        return false;
    }

    private static boolean isRejectAll(String preferredVersion, List<String> rejectedVersions) {
        return "".equals(preferredVersion) && DefaultResolvedVersionConstraint.hasMatchAllSelector(rejectedVersions);
    }

    private static boolean hasMatchAllSelector(List<String> rejectedVersions) {
        for (String version : rejectedVersions) {
            if (!"+".equals(version)) continue;
            return true;
        }
        return false;
    }
}

