/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "tools.h"

/***************************************************************************
@---------------------------------------------------------------------------
@
@  FILE: divide_by_gcd.c
@
@---------------------------------------------------------------------------
****************************************************************************/

/***************************************************************************
@---------------------------------------------------------------------------
@
@ int divide_by_gcd(matrix_TYP *A)
@
@ divides the entries of A->array.SZ by the positive gcd of it's entries,
@ and returns this gcd.
@
@---------------------------------------------------------------------------
****************************************************************************/
int divide_by_gcd(matrix_TYP *A)
{
  int g = labs(A->array.SZ[0][0]),
      i,
      j;

  for (i=0;i<A->rows && (g!=1);i++){
     for (j=0;j<A->cols && (g!=1);j++){
        g = labs(GGT(A->array.SZ[i][j],g));
     }
  }

  if (g!=1){
     for (i=0;i<A->rows;i++){
        for (j=0;j<A->cols;j++){
           A->array.SZ[i][j] = A->array.SZ[i][j]/g;
        }
     }
  }

  return g;
}
