/*
 * Decompiled with CFR 0.152.
 */
package plugins.svg;

import java.awt.print.Paper;
import java.util.HashMap;
import java.util.Map;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;

class ExportPdfPapers {
    private static final double ppmm = 3.7795275590551185;
    Map paperFormats = new HashMap();

    public ExportPdfPapers() {
        this.initPapers();
    }

    String[] getPaperNames() {
        Object[] o_names = this.paperFormats.keySet().toArray();
        String[] names = new String[o_names.length];
        for (int i = 0; i < this.paperFormats.size(); ++i) {
            names[i] = (String)o_names[i];
        }
        return names;
    }

    private void initPapers() {
        this.addPaper(MediaSizeName.ISO_A2, "A2");
        this.addPaper(MediaSizeName.ISO_A3, "A3");
        this.addPaper(MediaSizeName.ISO_A4, "A4");
        this.addPaper(MediaSizeName.ISO_A5, "A5");
        this.addPaper(MediaSizeName.ISO_B2, "B2");
        this.addPaper(MediaSizeName.ISO_B3, "B3");
        this.addPaper(MediaSizeName.ISO_B4, "B4");
        this.addPaper(MediaSizeName.ISO_B5, "B5");
    }

    private void addPaper(MediaSizeName name, String displayName) {
        MediaSize mSize = MediaSize.getMediaSizeForName(name);
        Paper paper = new Paper();
        paper.setSize((double)mSize.getX(1000) * 3.7795275590551185, (double)mSize.getY(1000) * 3.7795275590551185);
        this.paperFormats.put(displayName, paper);
    }

    Paper determinePaper(String format) {
        Object o = this.paperFormats.get(format);
        if (o != null && o instanceof Paper) {
            Paper result = (Paper)o;
            return result;
        }
        return null;
    }
}

