define(["browser","layoutManager","dom","focusManager","scrollStyles"],function(browser,layoutManager,dom,focusManager){"use strict";function disableOneEvent(event){event.preventDefault(),event.stopPropagation(),this.removeEventListener(event.type,disableOneEvent)}function within(number,min,max){return number<min?min:max<number?max:number}function onFrameClick(e){if(1===e.which){var focusableParent=focusManager.focusableParent(e.target);focusableParent&&focusableParent!==document.activeElement&&focusableParent.focus()}}function resetScrollTop(){this.scrollTop=0}function getBoundingClientRect(elem){return elem.getBoundingClientRect?elem.getBoundingClientRect():{top:0,left:0}}var wheelEvent=document.implementation.hasFeature("Event.wheel","3.0")?"wheel":"mousewheel",interactiveElements=["INPUT","SELECT","TEXTAREA"],abs=Math.abs,sqrt=Math.sqrt,pow=Math.pow,round=Math.round;var isSmoothScrollSupported="scrollBehavior"in document.documentElement.style;function Scroller(frame,options){var o=Object.assign({},{slidee:null,horizontal:!1,mouseWheel:!0,scrollBy:0,dragSource:null,mouseDragging:1,touchDragging:1,dragThreshold:3,intervactive:null,speed:0},options);!1===o.allowNativeScroll?o.enableNativeScroll=!1:isSmoothScrollSupported&&(browser.firefox&&!layoutManager.tv||o.allowNativeSmoothScroll)?o.enableNativeScroll=!0:o.requireAnimation&&(browser.animate||browser.supportsCssAnimation())?o.enableNativeScroll=!1:layoutManager.tv&&browser.animate||(o.enableNativeScroll=!0),browser.web0s&&(o.enableNativeScroll=!0);var slideeElement=(this.options=o).slidee?o.slidee:function(n,elem){for(var matched=[];n;n=n.nextSibling)1===n.nodeType&&n!==elem&&matched.push(n);return matched}(frame.firstChild)[0];this._pos={start:0,center:0,end:0,cur:0,dest:0},this.dragSourceElement=o.dragSource?o.dragSource:frame,this.currentDelta=0,this.initialized=0,this.slideeElement=slideeElement,this.options=o,this.dragging={released:1},this.contentRect={};var nativeScrollElement=o.horizontal&&slideeElement||frame;this.nativeScrollElement=nativeScrollElement,this.frame=frame,this.requiresReflow=!0,this.frameSize=0,this.slideeSize=0}function load(instance,isInit){if(instance.requiresReflow=!0,!isInit){instance.ensureSizeInfo();var pos=instance._pos;instance.slideTo(within(pos.dest,pos.start,pos.end))}}function onDragEnd(instance){var dragging=instance.dragging;dragging.released=!0;var dragHandler=instance.dragHandler;dragHandler&&(dom.removeEventListener(document,"pointermove",dragHandler,{passive:!0}),dom.removeEventListener(document,"pointerup",dragHandler,{passive:!0})),setTimeout(function(){dragging.source.removeEventListener("click",disableOneEvent)}),dragging.init=0}function onDragStart(event){var isTouch="touchstart"===event.type,dragging=this.dragging;if(!(dragging.init||!isTouch&&function(element){for(;element;){if(-1!==interactiveElements.indexOf(element.tagName))return!0;element=element.parentNode}return!1}(event.target))){var options=this.options;if(isTouch?options.touchDragging:options.mouseDragging&&event.which<2){isTouch||event.preventDefault(),dragging.released=0,dragging.init=0,dragging.source=event.target;var pointer=(dragging.touch=isTouch)?event.touches[0]:event;if(dragging.initX=pointer.pageX,dragging.initY=pointer.pageY,dragging.initPos=this._pos.cur,dragging.start=+new Date,dragging.time=0,dragging.path=0,dragging.delta=0,dragging.locked=0,dragging.pathToLock=isTouch?30:10,!options.enableNativeScroll){var thisDragHandler=this.dragHandler;dom.addEventListener(document,"pointermove",thisDragHandler,{passive:!0}),dom.addEventListener(document,"pointerup",thisDragHandler,{passive:!0})}}}}function setStyleProperty(elem,name,value,speed,resetTransition){var style=elem.style;(resetTransition||browser.edge)&&(style.transition="none",elem.offsetWidth),style.transition="transform "+speed+"ms ease-out",style[name]=value}function renderAnimateWithTransform(instance,fromPosition,toPosition,immediate){var options=instance.options,speed=options.speed;immediate&&(speed=options.immediateSpeed||50),options.horizontal?setStyleProperty(instance.slideeElement,"transform","translateX("+-round(toPosition)+"px)",speed):setStyleProperty(instance.slideeElement,"transform","translateY("+-round(toPosition)+"px)",speed),instance._pos.cur=toPosition,function(instance){instance.options.dispatchScrollEvent&&instance.frame.dispatchEvent(new CustomEvent(instance.getScrollEventName(),{bubbles:!0,cancelable:!1}))}(instance)}return Scroller.prototype.init=function(){if(!this.initialized){var options=this.options,frame=this.frame;if(options.enableNativeScroll){var nativeScrollElement=this.nativeScrollElement;options.horizontal?layoutManager.desktop&&!options.hideScrollbar?nativeScrollElement.classList.add("scrollX"):(nativeScrollElement.classList.add("scrollX"),nativeScrollElement.classList.add("hiddenScrollX"),layoutManager.tv&&!1!==options.allowNativeSmoothScroll&&nativeScrollElement.classList.add("smoothScrollX")):layoutManager.desktop&&!options.hideScrollbar?nativeScrollElement.classList.add("scrollY"):(nativeScrollElement.classList.add("scrollY"),nativeScrollElement.classList.add("hiddenScrollY"),layoutManager.tv&&!1!==options.allowNativeSmoothScroll&&nativeScrollElement.classList.add("smoothScrollY"))}else{frame.style.overflow="hidden";var slideeElement=this.slideeElement;slideeElement.style["will-change"]="transform",slideeElement.style.transition="transform "+options.speed+"ms ease-out",options.horizontal?slideeElement.classList.add("animatedScrollX"):slideeElement.classList.add("animatedScrollY")}var selfScrollHandler,dragStartHandler=onDragStart.bind(this);if(this.dragStartHandler=dragStartHandler,options.enableNativeScroll&&!layoutManager.tv||dom.addEventListener(this.dragSourceElement,"mousedown",dragStartHandler,{}),options.mouseWheel&&(selfScrollHandler=function(event){this.ensureSizeInfo();var pos=this._pos,options=this.options,scrollBy=options.scrollBy;if(!scrollBy||pos.start===pos.end)return;var delta=function(event,instance){var options=instance.options;return instance.currentDelta=(options.horizontal?event.deltaY||event.deltaX:event.deltaY)||-event.wheelDelta,options.enableNativeScroll||(instance.currentDelta/=1===event.deltaMode?3:100),instance.currentDelta}(event,this);options.enableNativeScroll?(isSmoothScrollSupported&&(delta*=12),options.horizontal?this.nativeScrollElement.scrollLeft+=delta:this.nativeScrollElement.scrollTop+=delta):(0<delta&&pos.dest<pos.end||delta<0&&(pos.dest,pos.start),this.slideBy(scrollBy*delta))}.bind(this),this.scrollHandler=selfScrollHandler),options.enableNativeScroll?options.horizontal&&options.mouseWheel&&dom.addEventListener(frame,wheelEvent,selfScrollHandler,{passive:!0}):(this.frameResizeObserver=new ResizeObserver(function(entries){var entry=entries[0];if(entry){var newRect=entry.contentRect;if(0===newRect.width||0===newRect.height)return;var contentRect=this.contentRect;this.options.horizontal?newRect.width!==contentRect.width&&(this.contentRect=newRect,load(this,!1)):newRect.height!==contentRect.height&&(this.contentRect=newRect,load(this,!1))}}.bind(this),{}),this.frameResizeObserver.observe(frame),dom.addEventListener(this.dragSourceElement,"touchstart",dragStartHandler,{passive:!0}),options.horizontal||dom.addEventListener(frame,"scroll",resetScrollTop,{passive:!0}),options.mouseWheel&&dom.addEventListener(frame,wheelEvent,selfScrollHandler,{passive:!0})),layoutManager.tv&&(dom.addEventListener(frame,"click",onFrameClick,{passive:!0,capture:!0}),options.centerFocus)){var focusHandler=this.focusHandler=function(e){var focused=focusManager.focusableParent(e.target);focused&&this.toCenter(focused)}.bind(this);dom.addEventListener(frame,"focus",focusHandler,{capture:!0,passive:!0})}return this.dragHandler=function(event){var dragging=this.dragging,options=this.options;dragging.released="pointerup"===event.type;var pointer=dragging.touch?event[dragging.released?"changedTouches":"touches"][0]:event;if(dragging.pathX=pointer.pageX-dragging.initX,dragging.pathY=pointer.pageY-dragging.initY,dragging.path=sqrt(pow(dragging.pathX,2)+pow(dragging.pathY,2)),dragging.delta=options.horizontal?dragging.pathX:dragging.pathY,dragging.released||!(dragging.path<1)){if(!dragging.init){if(dragging.path<options.dragThreshold)return dragging.released?onDragEnd(this):void 0;if(!(options.horizontal?abs(dragging.pathX)>abs(dragging.pathY):abs(dragging.pathX)<abs(dragging.pathY)))return onDragEnd(this);dragging.init=1}!dragging.locked&&dragging.path>dragging.pathToLock&&(dragging.locked=1,dragging.source.addEventListener("click",disableOneEvent)),dragging.released&&onDragEnd(this),this.slideTo(dragging.initPos-dragging.delta)}}.bind(this),this.initialized=1,load(this,!0),this}},Scroller.prototype.slideTo=function(newPos,immediate,fullItemPos){this.ensureSizeInfo();var pos=this._pos;newPos=within(newPos,pos.start,pos.end);var options=this.options;if(options.enableNativeScroll)!function(container,pos,immediate,scrollerOptions){container.scroll?scrollerOptions.horizontal?container.scroll({left:pos,behavior:immediate?"instant":"smooth"}):container.scroll({top:pos,behavior:immediate?"instant":"smooth"}):!immediate&&container.scrollTo?scrollerOptions.horizontal?container.scrollTo(Math.round(pos),0):container.scrollTo(0,Math.round(pos)):scrollerOptions.horizontal?container.scrollLeft=Math.round(pos):container.scrollTop=Math.round(pos)}(this.nativeScrollElement,newPos,immediate,options);else{pos.cur;immediate=immediate||this.dragging.init||!options.speed;var now=Date.now();options.autoImmediate&&!immediate&&now-(this.lastAnimate||0)<=50&&(immediate=!0),!immediate&&options.skipSlideToWhenVisible&&fullItemPos&&fullItemPos.isVisible||newPos!==pos.dest&&(renderAnimateWithTransform(this,0,pos.dest=newPos,immediate),this.lastAnimate=now)}},Scroller.prototype.getPos=function(item){var options=this.options,nativeScrollElement=this.nativeScrollElement,slideeOffset=getBoundingClientRect(options.enableNativeScroll?nativeScrollElement:this.slideeElement),itemOffset=getBoundingClientRect(item),offset=(options.horizontal?slideeOffset.left:slideeOffset.top,options.horizontal?slideeOffset.right:slideeOffset.bottom,options.horizontal?itemOffset.left-slideeOffset.left:itemOffset.top-slideeOffset.top),size=options.horizontal?itemOffset.width:itemOffset.height;size||0===size||(size=item[options.horizontal?"offsetWidth":"offsetHeight"]);var centerOffset=options.centerOffset||0;options.enableNativeScroll&&(centerOffset=0,options.horizontal?offset+=nativeScrollElement.scrollLeft:offset+=nativeScrollElement.scrollTop),this.ensureSizeInfo();var frameSize=this.frameSize,currentStart=this._pos.cur;return{start:offset,center:offset+centerOffset-frameSize/2+size/2,end:offset-frameSize+size,size:size,isVisible:currentStart<=offset&&offset+size<=currentStart+frameSize}},Scroller.prototype.ensureSizeInfo=function(){if(this.requiresReflow){this.requiresReflow=!1;var frame=this.frame,options=this.options;this.frameSize=options.horizontal?frame.offsetWidth:frame.offsetHeight;var slideeElement=this.slideeElement;this.slideeSize=options.scrollWidth||Math.max(slideeElement[options.horizontal?"offsetWidth":"offsetHeight"],slideeElement[options.horizontal?"scrollWidth":"scrollHeight"]),this._pos.end=Math.max(this.slideeSize-this.frameSize,0)}},Scroller.prototype.getScrollEventName=function(){return this.options.enableNativeScroll?"scroll":"scrollanimate"},Scroller.prototype.getScrollSlider=function(){return this.slideeElement},Scroller.prototype.addScrollEventListener=function(fn,options){var elem=this.options.enableNativeScroll?this.nativeScrollElement:this.frame;dom.addEventListener(elem,this.getScrollEventName(),fn,options)},Scroller.prototype.removeScrollEventListener=function(fn,options){var elem=this.options.enableNativeScroll?this.nativeScrollElement:this.frame;dom.removeEventListener(elem,this.getScrollEventName(),fn,options)},Scroller.prototype.getCenterPosition=function(item){this.ensureSizeInfo();var pos=this.getPos(item);return within(pos.center,pos.start,pos.end)},Scroller.prototype.getScrollPosition=function(){var options=this.options;return options.enableNativeScroll?options.horizontal?this.nativeScrollElement.scrollLeft:this.nativeScrollElement.scrollTop:this._pos.cur},Scroller.prototype.getScrollSize=function(){var options=this.options;return options.enableNativeScroll?options.horizontal?this.nativeScrollElement.scrollWidth:this.nativeScrollElement.scrollHeight:this.slideeSize},Scroller.prototype.slideBy=function(delta,immediate){delta&&this.slideTo(this._pos.dest+delta,immediate)},Scroller.prototype.to=function(location,item,immediate){if("boolean"===function(value){return null==value?String(value):"object"==typeof value||"function"==typeof value?Object.prototype.toString.call(value).match(/\s([a-z]+)/i)[1].toLowerCase()||"object":typeof value}(item)&&(immediate=item,item=void 0),void 0===item)this.slideTo(this._pos[location],immediate);else{var itemPos=this.getPos(item);itemPos&&this.slideTo(itemPos[location],immediate,itemPos)}},Scroller.prototype.toStart=function(item,immediate){this.to("start",item,immediate)},Scroller.prototype.toEnd=function(item,immediate){this.to("end",item,immediate)},Scroller.prototype.toCenter=function(item,immediate){this.to("center",item,immediate)},Scroller.prototype.destroy=function(){this.frameResizeObserver&&(this.frameResizeObserver.disconnect(),this.frameResizeObserver=null);var frame=this.frame,dragSourceElement=this.dragSourceElement;dom.removeEventListener(frame,"scroll",resetScrollTop,{passive:!0});var selfScrollHandler=this.scrollHandler;selfScrollHandler&&dom.removeEventListener(frame,wheelEvent,selfScrollHandler,{passive:!0});var dragStartHandler=this.dragStartHandler;dragStartHandler&&(dom.removeEventListener(dragSourceElement,"touchstart",dragStartHandler,{passive:!0}),dom.removeEventListener(dragSourceElement,"mousedown",dragStartHandler,{}));var focusHandler=this.focusHandler;return focusHandler&&dom.removeEventListener(frame,"focus",focusHandler,{capture:!0,passive:!0}),dom.removeEventListener(frame,"click",onFrameClick,{passive:!0,capture:!0}),this.scrollHandler=null,this.dragSourceElement=null,this.initialized=null,this.nativeScrollElement=null,this.frame=null,this.options=null,this.slideeSize=null,this._pos=null,this.requiresReflow=null,this.frameSize=null,this.lastAnimate=null,this.dragging=null,this.contentRect=null,this.dragHandler=null,this.dragStartHandler=null,this},Scroller.create=function(frame,options){var instance=new Scroller(frame,options);return Promise.resolve(instance)},Scroller});