/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.JSONUtil;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoResponse;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.socket.SocketConnection;

public class RhinoSocketConnection
extends SocketConnection {
    public RhinoSocketConnection(Socket socket) throws IOException {
        super(socket);
    }

    public void writePacket(Packet packet) throws IOException {
        String jsonString = JSONUtil.write(packet.toJSON());
        String count = Integer.toString(jsonString.length());
        Writer writer = this.getWriter();
        writer.write(count);
        writer.write(13);
        writer.write(10);
        writer.write(jsonString);
        writer.flush();
    }

    public Packet readPacket() throws IOException {
        int c;
        if (!this.isOpen()) {
            throw new IOException("Failed to read more packets: the socket is closed");
        }
        StringBuffer buffer = new StringBuffer();
        Reader reader = this.getReader();
        while ((c = reader.read()) != -1) {
            if (c == 13) break;
            buffer.append((char)c);
            if (buffer.length() <= 10) continue;
            throw new IOException("Invalid content length: " + buffer.toString());
        }
        int length = 0;
        try {
            length = Integer.parseInt(buffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Failed to parse content length: " + buffer.toString());
        }
        if (13 != c || '\n' != (char)reader.read()) {
            throw new IOException("Missing CRLF after content length");
        }
        char[] message = new char[length];
        int n = 0;
        int off = 0;
        while (n < length) {
            int count = reader.read(message, off + n, length - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        Map json = (Map)JSONUtil.read(new String(message));
        String type = RhinoPacket.getType(json);
        if ("event".equals(type)) {
            return new EventPacket(json);
        }
        if ("request".equals(type)) {
            return new RhinoRequest(json);
        }
        if ("response".equals(type)) {
            return new RhinoResponse(json);
        }
        throw new IOException("Unknown packet type: " + type);
    }
}

